/* mbed USBHost Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "USBHostSocketModem.h"
#include "dbg.h"

#define DEVICE_TO_HOST  0x80
#define HOST_TO_DEVICE  0x00
//Communications and CDC Control Class
#define CDCCONTROL 0x2
//CDC Data Class
#define CDCDATA 0xA
//CDC Set Control Line State Request
#define SET_CONTROL_LINE_STATE 0x22
//CDC Request Type
#define DTR_REQUEST_TYPE 0x21
//Set Bits of SetControlLineState register to Enable DTR
#define DTR 0x0003


USBHostSocketModem::USBHostSocketModem()
{
    host = USBHost::getHostInst();
    init();
}

void USBHostSocketModem::init() 
{
    dev_connected = false;
    dev = NULL;
    bulk_in = NULL;
    bulk_out = NULL;
    int_in = NULL;
    int_out = NULL;
    dev_connected = false;
    sm_intf = -1;
    sm_device_found = false;
    dev_connected = false;
    nb_ep = 0;
}


bool USBHostSocketModem::connected()
{
    return dev_connected;
}

bool USBHostSocketModem::connect()
{

    if (dev_connected) {
        return true;
    }

    for (uint8_t i = 0; i < MAX_DEVICE_CONNECTED; i++) {
        if ((dev = host->getDevice(i)) != NULL) {
            
            USB_DBG("Trying to connect SocketModem device\r\n");
            if(host->enumerate(dev, this)){
                printf("didn't fully enumerate\n");
                break;
            }
            
            if (sm_device_found) {
                //Set DTR
                USBHostSocketModem::setDTR();
                int_out = dev->getEndpoint(int_intf, INTERRUPT_ENDPOINT, OUT);
                bulk_out = dev->getEndpoint(bulk_intf, BULK_ENDPOINT, OUT);
                if (bulk_in == NULL){
                    printf("bulk_in == NULL\n");
                }
                bulk_in = dev->getEndpoint(bulk_intf, BULK_ENDPOINT, IN);
                printf("!SocketModem Found!\n");
                
                if (!bulk_in || !bulk_out){
                    continue;
                }

                USB_INFO("New SocketModem device: VID:%04x PID:%04x [dev: %p - intf: %d]", dev->getVid(), dev->getPid(), dev, sm_intf);
                dev->setName("SocketModem", bulk_intf);
                host->registerDriver(dev, bulk_intf, this, &USBHostSocketModem::init);

                dev_connected = true;
                return true;
            }
        } //if()
    } //for()
    init();
    return false;
}

/*virtual*/ void USBHostSocketModem::setVidPid(uint16_t vid, uint16_t pid)
{
    // we don't check VID/PID for MSD driver
}

/*virtual*/ bool USBHostSocketModem::parseInterface(uint8_t intf_nb, uint8_t intf_class, uint8_t intf_subclass, uint8_t intf_protocol) //Must return true if the interface should be parsed
{
    //Debug print statements
    //printf("Parsing Interface\n");
    //printf("class = %i\n",intf_class);
    //printf("subclass = %i\n",intf_subclass);
    //printf("msd_intf = %i\n",msd_intf);
    //printf("intf_class = %i\n",intf_class);
    if ((sm_intf == -1) && (intf_class == CDCCONTROL))
    {
        sm_intf = intf_nb;
        int_intf = intf_nb;
        //printf("parse interface: sm_intf = %i\n", sm_intf);
        return true;
    }
    else if ((sm_intf == 0) && (intf_class == CDCDATA))
    {
        sm_intf = intf_nb;
        bulk_intf = intf_nb;
        //printf("parse interface: sm_intf = %i\n", sm_intf);
        return true;
    }
    return false;
}

/*virtual*/ bool USBHostSocketModem::useEndpoint(uint8_t intf_nb, ENDPOINT_TYPE type, ENDPOINT_DIRECTION dir) //Must return true if the endpoint will be used
{
    //printf("Setting up Endpoint\n");
    if ((intf_nb == int_intf) || (intf_nb == bulk_intf)){
        /*if (type == INTERRUPT_ENDPOINT)*/
        if ((type == BULK_ENDPOINT) || (type == INTERRUPT_ENDPOINT)){
            //printf("type == %s\n", type);
            nb_ep++;
            if (nb_ep == 2)
                //printf("nb_ep == 2\n");
                sm_device_found = true;
            return true;
        }
    }
    return false;
}

void USBHostSocketModem::setDTR()
{
    //Set USB DTR to enable communication
    int res = host->controlWrite(dev, DTR_REQUEST_TYPE, SET_CONTROL_LINE_STATE, DTR, 0, NULL, 0);
}

void USBHostSocketModem::testAT()
{
    uint8_t buf[] = "AT\r";
    uint8_t result[64] = {0};
    int rc,rt,i;
    rc = host->bulkWrite(dev, bulk_out, buf, sizeof(buf));
    printf("rc = %i\n", rc);
    rt = host->bulkRead(dev, bulk_in, result, sizeof(result));
    printf("rt = %i\n", rt);
    for (i = 0;i<sizeof(result);i++){
        printf("result %i = %i\n", i, result[i]);
    }
}




