#include<iostream>
#include "mbed.h"
//#include <bitset>
#include "arduino.h"
 
#define delay_time 0
#define outlets 11

//using namespace mbed::mbed;
 
//DigitalOut lat(P8_11);
//DigitalOut dat(P8_13);
//DigitalOut clk(P4_4);
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut latch = P8_11;
DigitalOut CLK_595 = P8_13;
DigitalOut data_out_pins[outlets][3] = {
    {P4_4, P4_5, P4_6},
    {P1_2, P1_3, P10_12},
    {P10_14, P10_13, P8_14},
    {P1_8, P1_9, P1_10},
    {P1_13, P1_15, P1_7},
    {P10_0, P1_1, P1_0},
    {P2_7, P2_6, P2_5},
    {P2_3, P2_2, P2_1},
    {P7_15, P8_1, P2_9},
    {P4_0, P2_13, P5_7},
    {P5_3, P5_2, P5_1},};
DigitalIn data_in_pins[outlets] = {P4_7,P10_15,P8_15,P1_11,P1_6,P1_12,P2_4,P2_0,P2_10,P5_6,P5_0};
DigitalOut CLK_165(P2_14);
DigitalOut load(P2_15); 
 
uint8_t data_read;
bool c1[4];
bool c2[4];
bool c3[4];
bool c4[4];
uint8_t data_in[outlets];
uint8_t data_out[outlets][3] = {{0xC5, 0xB2, 0x68}};
 
void shift(){
//    DigitalOut lat = pins[row_no][0];
//    DigitalOut dat = pins[row_no][1];
//    DigitalOut clk = pins[row_no][2];
    CLK_595 = 0;
    latch = 0;
    int init = 0x80;
    for(int i=0; i<8; i++)
    {
        for (int j=0; j<outlets; j++)
        {
            data_out_pins[j][0] = data_out[j][0] & (init>>i);
            data_out_pins[j][1] = data_out[j][1] & (init>>i);
            data_out_pins[j][2] = data_out[j][2] & (init>>i);
        }
        CLK_595 = 1;
        CLK_595 = 0;
    }
    latch = 1;
    latch = 0;
}
 
void shift_read(){
    load = 0;
    load = 1;
    for (int i=0; i<outlets; i++)
    {
        data_in[i] = (data_in[i]<<1)|data_in_pins[i];
    }
    for(int i=0; i<8; i++)
    {
        for (int i=0; i<outlets; i++)
        {
            data_in[i] = (data_in[i]<<1)|data_in_pins[i];
        }
        CLK_165 = 0;
        CLK_165 = 1;
    }
 }
 
void call(){
    data_out[0][0] = pc.getc();
    shift();
    }
 
int main() {
    pc.attach(&call);
    long time_counter1 = 0;
    wait_ms(500);
    cout<<"Starting: "<<endl;
    wait_ms(500);
    while(1){
        shift();
        shift_read();
        time_counter1++;
        if (time_counter1 == 1000000)
        {
            //pc.printf("%X\n", data_in[0]);
            cout<<"Flag"<<endl;
            time_counter1 = 0;
        }
    }
}