#ifndef PID_CNTRL_H_
#define PID_CNTRL_H_

// PID Controller Class
class PID_Cntrl
{
public:

    PID_Cntrl(float Kp, float Ki, float Kd, float Tf, float Ts, float Min, float Max);

    float operator()(float error) {
        return update((double)error);
    }

    virtual     ~PID_Cntrl();

    void        reset(float initValue);
    float       update(double error);
    
private:

    // controller parameters (member variables)
    float Kp, Ki, Kd, Tf, Ts, Min, Max;
    // storage for signals (member variables)
    float yI, yD, e_old;
};

#endif

