/*
    PID-T1 Controller class

                      1           s
      G(s) = Kp + Ki --- + Kd ---------
                      s       T_f*s + p

    Eigther reseting the Nucleo via the black button or save a new software on 
    the Nucleo sets the analog output to zero. Zero is equal to -4 Ampere!!!
    Therefor: NEVER !!! reset or save a new software while the VC is powered on
    (the green button on the VC is glowing green)                      

*/

#include "PID_Cntrl.h"
using namespace std;

PID_Cntrl::PID_Cntrl(float Kp, float Ki, float Kd, float Tf, float Ts, float Min, float Max)
{
    
    // link member variables
    this->Kp = Kp;
    this->Ki = Ki;
    this->Kd = Kd;
    this->Tf = Tf;
    this->Ts = Ts;
    this->Min = Min;
    this->Max = Max;
    
    reset(0.0f);
}

PID_Cntrl::~PID_Cntrl() {}

void PID_Cntrl::reset(float initValue)
{

    // implement controller reset
    yI = initValue;
    yD = 0.0;
    e_old = 0.0;
}
//-------------------------------------------------
float PID_Cntrl::update(double e)
{

    // controller update function 
    
    // calculate uI
    yI += Ki * Ts * e;
    
    // saturate uI, uMin <= uI <= uMax (anti-windup for the integrator part)
    if(yI > Max) 
        yI = Max;
    else if(yI < Min)
        yI = Min;

    // calculate uD
    yD = (1 - Ts/Tf)*yD + Kd/Tf * (e - e_old);
    
    float y = Kp * e + yI + yD;
        
    // saturate u, uMin <= u <= uMax
    if(y > Max) 
        y = Max;
    else if(y < Min)
        y = Min;
    
    // update signal storage
    e_old = e;
    
    return y;
}

