//  I had modified for a GR-PEACH beta, 
//  the eVY1 Sample program by Switch Science Switch Science eVY1,
//  Hirofumi Inomata, 2014
// 
#include "mbed.h"

DigitalOut myled(LED1);
Serial miku( D1, D0 ); // tx, rx
#define delay(ms) wait_ms( (ms) )

void setup(void);
void loop(void);

int main() {
    myled = 1;
    setup();
    myled = 0;
    
    for(;;) {
        loop();   
    }
}

int len = 0;
unsigned char buf[4096];
void Short_Message(int cmd, int d1, int d2);
void lylic_send(int num);

void setup() {
    miku.baud( 31250 );
    wait(10);    // 10sec until starting a Miku
}

//変更しない
const char* phoneticSymbols[] = {
    "a", "i", "M", "e", "o",        // あいうえお0-4
    "k a", "k' i", "k M", "k e", "k o",    // かきくけこ5-9
    "s a", "S i", "s M", "s e", "s o", // さしすえそ10-14
    "t a", "tS i", "ts M", "t e", "t o",    // たちつてと15-19
    "n a", "J i", "n M", "n e", "n o",    //なにぬねの20-24
    "h a", "C i", "p\\ M", "h e", "h o",    // はひふへほ25-29
    "m a", "m' i", "m M", "m e", "m o", // まみむめも30-34
    "j a","i", "j M","e","j o",//やいゆえよ35-39
    "4 a", "4' i", "4 M", "4 e", "4 o", // らりるれろ40-44
    "w a","w o","N\\","","",// わをん 45-49
    "g a", "g' i", "g M", "g e", "g o",//がぎぐげご　50-54
    "dz a", "dZ i", "dz M", "dz e", "dz o",//ざじずぜぞ55-59
    "d a", "dZ i", "dz M", "d e", "d o",//だじづでど60-64
    "b a", "b' i", "b M", "b e", "b o",//ばびぶべぼ    65-69
        "p a", "p' i", "p M", "p e", "p o"//ぱぴぷぺぽ70-74
}; 

//歌詞
//かえるのうたがきこえてくるよ
int lylics[]={5,3,42,24,2,15,50,6,9,3,18,7,42,39};
char mml[] ="CDEFEDC EFGAGFE";

void loop() {
  
  int key = 0x3c; //C
  int wait =500;

  myled = 1;  
  int lylic_len = sizeof(lylics) / sizeof(lylics[0]);
  lylic_send(lylic_len);
  
  int mml_len = sizeof(mml) / sizeof(mml[0]);
  for(int i = 0;i< mml_len ;i++){
    char c = mml[i];
    if(c >= 'a' && c <='z') c-= 0x20;
    if((c>='A' && c<='Z')||c=='<'||c=='>'){
       //key send
       if(i!=0){
         Short_Message(0x90,key,0x7f);   
         delay(wait);
       }
       key= 0x3c; 

        switch(c) {
            case 'C': break;
            case 'D': key+=2; break;
            case 'E': key+=4; break;
            case 'F': key+=5; break;
            case 'G': key+=7; break;
            case 'A': key+=9; break;
            case 'B': key+=11; break;
            default: break;
        }
    }
  }
  Short_Message(0x90,key,0x7f);   
  myled = 0;  
  delay(wait);
}

void Short_Message(int cmd, int d1, int d2) {
  miku.putc(cmd);
  miku.putc(d1);
  miku.putc(d2);
}

//lylic send
void lylic_send(int num){
  //hedaer
  len = 0; 
  miku.putc( 0xF0 );
  miku.putc( 0x43 );
  miku.putc( 0x79 );
  miku.putc( 0x09 );
  miku.putc( 0x00 );
  miku.putc( 0x50 );
  miku.putc( 0x10 );
  
  for(int i=0;i<num;i++){
    unsigned char cc;
    if(i != 0) {
        miku.putc( 0x2c ); // buf[len++] = 0x2c;
    }
    for ( int j =0;; j++ ) {
      cc = (phoneticSymbols[lylics[i]])[j];
      if ( cc == 0x00 ) break;
      miku.putc( cc );  // buf[len++] = cc;
    }
  }
  //footer
  miku.putc( 0x00 );
  miku.putc( 0xF7);
}
