#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"
#include "confETH.h"



int var;

DigitalIn button(USER_BUTTON);
char varc; 

int main()
{   
    var = button.read();  
    
    EthernetInterface eth;
    eth.set_network(IP,MASK,GATEWAY);
    eth.connect();
    TCPServer srv;
    TCPSocket clt_sock;
    SocketAddress clt_addr;
    
    srv.open(&eth); //Open the server on ethernet stack
    srv.bind(eth.get_ip_address(), 80); //Bind the HTTP port (TCP 80) to the server
    srv.listen(1); //Can handle 1 simultaneous connections
    
    wait(2); //2sec
    
    srv.accept(&clt_sock, &clt_addr);
    clt_sock.send(MESSAGE_INVITE, strlen(MESSAGE_INVITE));
    while (true) {
        srv.accept(&clt_sock, &clt_addr);
        sprintf(&varc, "%d", button.read());
        clt_sock.send(&varc, strlen(&varc));
    }
}