 #include "MPR121.h"
 #include "mbed.h"
 #include "TextLCD.h"
 #include "SDFileSystem.h"
 #include <VLSIcodec.h>

#define BUFFER_SIZE 2048
#define play 0x0001
#define stop 0x0010
#define pause 0x0100
#define Vhigh 0x0002
#define Vdown 0x0020
#define previous 0x0004
#define next 0x0040

Serial com(USBTX, USBRX); //Initiallize the Serial Port 0 (9600 bits/sec)
    // codec
VS1053Codec codec(p11, p12, p13, p14, p16, p15, p17); // mosi, miso, sck, cs,  dreq, rst, bsync
 // SD card
SDFileSystem sd(p5, p6, p7, p8, "sd"); //  mosi, miso, sclk, cs   the pinout on the mbed Cool Components workshop board 
    // I2C Communication
/*I2C i2c_lcd(p9, p10 ); // SDA, SCL */
 I2C i2c(p28, p27); //SDA, SCL 
    // LCD
TextLCD_I2C lcd(&i2c, 0x40, TextLCD::LCD16x2);  // I2C bus, PCF8574 Slaveaddress, LCD Type
    //Touch_pad
 InterruptIn irq(p26);
 MPR121 touch_pad(i2c, irq, MPR121::ADDR_VSS );
 
 unsigned char buff[BUFFER_SIZE];
 int check=0;
 Timer timer; 
 
 int main()  
{       
     touch_pad.init();           //initialisation du touch_pad
     touch_pad.enable();         //activation du touch_pad
     uint16_t button_val;        // variable recueillant la valeur du bouton
     bool lecture=0;             //booléen conditionnant l'etat play
     int right=0x30, left =0x30; //initialisation des valeurs de volumes de départ
     int temps = 0 ;
     FILE *song;
     char ligne[13],time[10];
     int aff=0;
     char *title_song[8]={"wind", "toreador", "Moove", "Pirate", "DBZ", "Safe", "yolanda"};
    
     
    lcd.cls();
    lcd.setBacklight(TextLCD::LightOff);
    wait(1);
    lcd.printf("     ");
    lcd.cls();
    lcd.setBacklight(TextLCD::LightOn);
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    mkdir("/sd/mydir", 0777);
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) 
    {
        error("Could not open file for write\n");
    }
    fprintf(fp, "IUT---MP3");
    fclose(fp);
    fp = fopen("/sd/mydir/sdtest.txt", "r");
    fscanf(fp,"%s",ligne);
    lcd.printf(ligne);
    fclose(fp);

   
    //
    codec.init();                      // initialise le codec
    codec.loadpatch();                 // charge le patch (rev 1.5)
    codec.setbassboost( 15, 150);      // basse
    codec.settrebleboost( 7, 15000);   // aigue
    codec.setvolume(right, left);      // volume
    
    int song_number=1;
    char str[16] = "/sd/music/";  
     
    printf("\n Ouverture fichie \n \n");
    wait(1);
    
    codec.resetplaytime();   
    
     
     while(1)
    {
       
         button_val=touch_pad.buttonPressed();
         printf("\n button = 0x%04x \n", button_val);       
         
         typedef enum{e_primordial, e_init, e_play, e_pause, e_next, e_previous, e_stop,e_suite}type_etat;
         static type_etat etat=e_primordial;
        
          switch(etat)
         {    
              case e_primordial : 
              if(button_val==play)etat=e_init;
              break;
              
              case e_init : 
              lecture=1;
              sprintf(str+10,"%d",song_number);   //donne le numéro de la musique
              strcat(str,".mp3");                 //concatene le numero avec l'extension de la musique
              song = fopen(str, "r");
              etat = e_play;
              break;
              //Play
              
              case e_play :      
              lcd.cls();  
              lcd.locate(0,0); 
              lcd.printf("%d %s",song_number,title_song[song_number]);                                                                     
              while(lecture)
             {    
                 
                  timer.start();
                  printf("feof \n");
                  fread(buff, 1, BUFFER_SIZE, song);  // lecture buffer 
                  printf("lecture buffer \n");
                  lcd.locate(9,1);
                  lcd.printf("PLAY");
                  aff++;
                  if(aff%1==0){
                  codec.getplaytime(ligne);
                  ligne[5]=NULL;
                  lcd.locate(1,1);
                  lcd.puts(ligne);}
                  
                  int iSize=0;
                  for( iSize=0;iSize < BUFFER_SIZE;iSize++) 
                {
                  codec.testdreq();
                  codec.writedata( buff[ iSize]);
                }
                 if(feof(song)&&button_val==0x0000)
                 {   
                     printf("fin du fichier \n");
                     codec.resetplaytime();
                     etat=e_next;
                 }
                 
                 button_val = touch_pad.buttonPressed();
                 if(button_val==stop)//stop
                     {
                     lecture=0;
                     etat=e_stop;
                     }
                    
                 if(button_val==0x0004)//previeous
                   {
                     lecture=0;
                     wait(0.5);
                     etat=e_previous;
                   }
                 if(button_val==0x0040)//next
                   { 
                   lecture=0;
                   wait(0.5);
                   etat=e_next;
                   }
                  if(button_val==0x0020)//augmenter la volume
                   {
                    if(temps%1==0)
                     {
                      codec.setvolume(right--, left--);
                      printf("Volume++ \n");
                      lcd.locate(12,0);
                      lcd.printf("Vol+");
                      //affiche=0;
                     }
                   }  
                   
                  if(button_val==0x0002)//dimunuer la volume
                  {
                    if(temps%1==0)
                     {
                      codec.setvolume(right++, left++);
                      printf("Volume-- \n");
                      lcd.locate(12,0);
                      lcd.printf("Vol-");
                     }
                   }  
                   
                   if(button_val==pause)//pause
                     {
                       lecture=!lecture;
                       etat = e_pause;   
                     }
                     
                     if(button_val==0x000)//augmenter la volume
                   {
                     lcd.locate(10,0);
                     lcd.printf("      ");
                   }   
                 
               }
              break;
              //Stop
             
             case e_stop :
             printf("stop \n");
             lcd.locate(9,1);
             lcd.printf("Stop");
             lecture=0;
             fclose(song);
             codec.resetplaytime();
             song  = fopen(str, "r"); 
             if(button_val==play)etat=e_init;
             if(button_val==0x0004)//previeous
                   {
                     lecture=0;
                     wait(1);
                     etat=e_previous;
                   }
             if(button_val==0x0040)//next
                   { 
                   lecture=0;
                   wait(1);
                   etat=e_next;
                   }
             break;
             
             //Pause
             
             case e_pause : 
             printf("\n button = 0x%04x \n", button_val);
             printf("pause \n");
             lcd.locate(9,1);
             lcd.printf("Pause");
             if(button_val==play)
             { 
                 lecture=1;
                 etat=e_play; 
             }
              if(button_val==0x0004)//previeous
                   {
                     lecture=0;
                     wait(1);
                     etat=e_previous;
                   }
              if(button_val==0x0040)//next
                   { 
                   lecture=0;
                   wait(1);
                   etat=e_next;
                   }
              if(button_val==stop)
              {  
                  lcd.locate(9,1);
                  lcd.printf("     ");
                  etat=e_stop;
              }
              if(button_val==0x0020)//augmenter la volume
              {
                    if(temps%1==0)
                     {
                      codec.setvolume(right--, left--);
                      printf("Volume++ \n");
                      lcd.locate(12,0);
                      lcd.printf("Vol+");
                      
                     }
                }  
                   
               if(button_val==0x0002)//dimunuer la volume
                { 
                  if(right<=0x00 && left<=0x00)
                    { 
                          codec.setvolume(0x00, 0x00);
                          printf("volume  max");
                    }
                   else
                   { 
                    if(temps%1==0)
                     {
                      codec.setvolume(right++, left++);
                      printf("Volume-- \n");
                      lcd.locate(12,0);
                      lcd.printf("Vol-");
                       
                     }
                    }
                }  
                     
                if(button_val==0x000)//augmenter la volume
                {
                     lcd.locate(10,0);
                     lcd.printf("      ");
                }   
             break; 
             //Next 
             
             case e_next :
             lcd.locate(9,1);
             lcd.printf("Next");
             wait(0.5);
             codec.resetplaytime();
             song_number++;
             if(song_number==7)song_number=0;
             lecture=1;
             printf("Next \n");
             etat=e_init;
             break;
             //Previous
             
             case e_previous :
             lcd.locate(7,1);
             lcd.printf("Previous");
             wait(0.5);
             codec.resetplaytime();
             song_number--;
             if(song_number<0)song_number=6;
             lecture=1;
             printf("Previous \n");
             etat=e_init;
             break;
             
             default:             
             printf("error");
             break;
        }
       }
      
 }  
   
 