#include "mbed.h"
#include "Stepper.h"
#include "string"
DigitalIn optic(D5);
Stepper mot(D3,D2); //(PUL+,DIR+)
DigitalOut en(D4);
Serial pc(USBTX, USBRX);

int main()
{
optic.mode(PullDown);
wait(0.1);
int steps = 0;
int slot = 0;
en = 1; // stepper motor off
wait(1);
mot.setSpeed(400); //stepper speed
mot.setPositionZero(); //set origin for stepper steps 
while(1)
  {
        pc.printf("\n\n\nEnter desired position: ");
        pc.scanf("%d",&slot); 
        
        en = 0; //turns on stepper driver
        mot.goesTo(slot*1000); // move to absolute slot*500 step position
        while(!mot.stopped()); // while motor is turning...do line below
        steps = mot.getPosition(); //read in absolute step postition
        pc.printf("\nIn Position");
        en = 1; //disable the motor and driver
    }
}
