#include "mbed.h"
#include "TFC.h"
#define CAM_THRESHOLD 3000


DigitalOut myled(LED1);

int main() {
    TFC_Init();
    
    uint32_t i,t = 0;
    uint32_t width = 0;
    char curr_line[129];
    
    /* Ensure string is null terminated */
    curr_line[128] = 0; 

    
    printf("Starting camera test program\n");
    
    while(1) {
        //If we have an image ready
        if(TFC_LineScanImageReady>0)
            {
                //Reset image ready flag
                TFC_LineScanImageReady=0;
                printf("\r\n");
                //printf("L:");
                
                //Strange thing that cycles the battery indicator
                //Leaving in as this is a good indicator that the camera test program is running
                if(t==4)
                    t=0;
                else
                    t++;  
                TFC_SetBatteryLED_Level(t);
                   
                   //Loop through camera pixels
                   for(i=0;i<128;i++)
                   {
                       //If the pixel value exceeds our threshold, print a 1
                       if (TFC_LineScanImage0[i] > CAM_THRESHOLD) 
                       {
                           curr_line[i] = '1';
                           width++; //Increment the width value
                       }
                       //Else, print a 0
                       else
                       {
                          curr_line[i] = '0';  
                       }
                   }
                   printf("%s\n",curr_line);
                    
                    printf("Width: %d\n", width);
                    width = 0;
                   
               }
    }
}
