#include "mbed.h"
#include "xbee.h" // Include for xbee code
#include "C12832_lcd.h" // Include for LCD code

char sjekk_XBeeB(char nr);
void Menu();
void set_array();
void send_array();
void reset();
void get_array();
char print_array(char *arr_name);

//  ################################
//  ################################
//  ###  XBee A (med LCD skjerm) ###
//  ################################
//  ################################

//xbee xbee1(p9,p10,p11); //Initalise xbee_lib varName(rx,tx,reset)

Serial xbee(p9, p10);
DigitalOut rst(p11);

BusIn bryter[8] = {p12, p13, p14, p15, p16, p17, p18, p19};
// Brytere 1 - 8 på XBee A.
char check_array[10] = {0, 0, 0, 0, 0, 0, 0, 0};
char digital_in_array_b[8] = {0, 0, 0, 0, 0, 0, 0, 0};

DigitalOut b1(p21), b2(p22), b3(p23), b4(p24);
Serial pc(USBTX, USBRX); //Initalise PC serial comms
C12832_LCD lcd; //Initialize LCD Screen

char recieveData;

//Code to send strings acsross xbee with xbee.h
//Code should be on the End Device
int main()
{
    Menu();

    lcd.printf("Starting oppg2_vol1");
    wait(2);
    reset();

    //Establish a variable to receive data from End Device
    //Max buffer is 202
//   char receiveData[4];

    //Setup LCD screen
    lcd.cls();
    lcd.locate(0,1);


    /*for (int b=0; b<=7; b++) {
        if (check_array[b] != 0) {
            pc.printf("\n Sjekker punkt nr: %d ", b);
        }
    }*/
}

/*char sjekk_XBeeB(int nr)
{

    pc.printf("yoo");
    char kommando;
    //kommando[0]=0; //0xxx (xxx = nr)

    //char *strcat(char *dest, const char *src)
    char *strcat(char *kommando, const char *nr);

    //str.append(kommando);
    //str.append(nr);


    xbee.printf("yoo");
    return 1;*/
//}


//void Menu(int innlogget) //Meny funksjonen (krever input av passord variabel. Blir satt til 1 ved rett passord)
void Menu()
{
    //while (innlogget == 1) { //Ved riktig passord (logget inn)
    pc.printf(" \r \n\n Trykk for onsket valg: \n 1. Sjekke status Digitale innganger \n 2. Sjekke status LEDs \n 3. Stille LEDs \n 4. Sjekke status analog inngang");
    switch(getchar()) {
        case '1': //Sjekke status Digitale innganger
            pc.printf("\r\n\n Sjekke status paa digitale innganger \n\n");
            set_array(); // Denne sjekker brytere på Xbee A som bestemmer hvilke punkter som skal kontrolleres på XBee B
            print_array(check_array);
            wait(2);
            send_array();
            wait(6);
            get_array();
            wait(2);
            print_array(digital_in_array_b);
            //reset();
            wait(1);

            break;

        case '2': //Sjekke status LEDs
            pc.printf("\r\n\n Sjekke staus paa LEDs \n\n");

            break;

        case '3': //Stille LEDs
            pc.printf("\r\n\n Stille LEDs \n\n");

            break;
        case '4': //Sjekke status Analog inngang
            pc.printf(" \n Sjekke staus paa Analog inngang \n\n");

            break;


        default:
            pc.printf(" \r \n Ugyldig valg!");
    }
}

void set_array()
{
    for (int i=0; i<=7; i++) {
        if (bryter[i] != 0) {
            //xbee.printf("%c", i);
            //pc.printf("\nsjekk verdi pa bryter nr: %d ", i);
            //Setter bryter/led nr til array)
            check_array[i] = 1;

            //char status = sjekk_XBeeB(i);
            //pc.printf("Status for bryter %d er %d", i, status);
        }
    }
}

void send_array() //sender over hele arrayet
{
    for (int c=0; c<=7; c++) {
        //if (check_array[c] !=0) {
        //xbee.printf("%c", c);
        //xbee.printf("%c", check_array[c]);
        xbee.putc(check_array[c]);
        //}
    }
    pc.printf("\n array sendt \n");
}

void get_array() //Leser array sendt fra xbee og lagrer dette lokalt
{
    if (xbee.readable()) {
        for (uint8_t i = 0; i <= 7; i++) {
            if (xbee.readable()) {
                digital_in_array_b[i] = xbee.getc();
                //pc.printf("\n\n %d Sjekk verdi pa bryter nr: %d", i, digital_in_array_b[i]);

           } else {
                digital_in_array_b[i] = NULL;
                pc.printf("\n feil under mottak\n");
            }
            wait_ms(5);
        }

        //Tømmer bufferet i tilfelle det dukker opp input som ikke hører hjemme
        while (xbee.readable()) {
            xbee.getc();
            wait_ms(5);
        }
    }
}

void reset()
{
    // reset the xbees (at least 200ns)
    rst = 0;
    wait_ms(1);
    rst = 1;
    wait_ms(1);
}

char print_array(char *arr_name) {
    pc.printf("\n");
    for (int d=0; d<=7; d++) {
        //pc.printf("\n Skriver ut array %d", *arr_name);
        pc.printf("\n index_nr: %d , verdi: %d \n", d, arr_name[d]);
    }
}


/*for (int b=0; b<=7; b++)
{
    //if (check_array_a[b] != 0) {
    if ((recievedmessage[b] == b) && (b !=0)) {
        check_array_a[b] = 1;
    }
    pc.printf("\n Lest fra array, nr: %d er verdi: %d", b, check_array_a[b]);
    wait(1.5);
    //}
}
}*/