#include "main.h"

//XBee B med bargraph og digitale innganger + potmeter

Serial xbee(p9, p10);
Serial pc(USBTX, USBRX);
DigitalOut rst(p11);
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalIn sb(p8);
BusIn bryter[8] = {p12, p13, p14, p15, p16, p17, p18, p19};
DigitalOut leds[8] = {p21, p22, p23, p24, p25, p26, p27, p28};
char check_array_a[8] = {0, 0, 0, 0, 0, 0, 0, 0};
char digital_in_array[8] =  {0, 0, 0, 0, 0, 0, 0, 0};

AnalogIn ain(p20);
char recievedmessage[8];

void read_command();
void reset();
void check_digital_in();
void get_array();
void send_array(char *arr_name);

int main()
{
    reset();
    while(1) {
        read_command();
        get_array();
        check_digital_in();
        send_array(digital_in_array);
    }
}

void read_command()
{
    if (xbee.readable()) {
        //Henter kommando og eventuell info for LEDs
        //xbee.gets(recievedmessage, sizeof(recievedmessage));
        //xbee.scanf("%s", recieveptr);
        for (uint8_t i = 0; i <= 7; i++) {
            if (xbee.readable()) {
                //recievedmessage[i] = xbee.getc();
                check_array_a[i] = xbee.getc();
                pc.printf("\n\n %d Sjekk verdi pa bryter nr: %d", i, check_array_a[i]);

            } else {
                recievedmessage[i] = NULL;
            }
            wait_ms(5);
        }

        //Tømmer bufferet i tilfelle det dukker opp input som ikke hører hjemme
        while (xbee.readable()) {
            xbee.getc();
            wait_ms(5);
        }
    }
}

void check_digital_in() //sjekker om lokal digital input er satt til 1 og lagrer verdier i array
{
    for (int a=0; a<=7; a++) {
        if (bryter[a] != 0) {
            digital_in_array[a] = 1;
            //bryter_nr[a] = a;
            //xbee.putc(x);
        } else {
            digital_in_array[a] = 0;
        }
    }
}

void reset()
{
    // reset the xbees (at least 200ns)
    rst = 0;
    wait_ms(1);
    rst = 1;
    wait_ms(1);
}

void get_array() //Leser array sendt fra xbee og lagrer dette lokalt
{
    for (int b=0; b<=7; b++) {
        //if (check_array_a[b] != 0) {
        if ((recievedmessage[b] == b) && (b !=0)) {
            check_array_a[b] = 1;
        }
        pc.printf("\n Lest fra array, nr: %d er verdi: %d", b, check_array_a[b]);
        wait(1.5);
        //}
    }
}

void send_array(char *arr_name) //sender over hele arrayet
{
    for (int c=0; c<=7; c++) {
        //if (check_array[c] !=0) {
        //xbee.printf("%c", c);
        //xbee.printf("%c", check_array[c]);
        xbee.putc(arr_name[c]);
    }
    pc.printf("\n array sendt \n");
}
