/*
 * Mbed OS device driver for Semtech TS13401 Neo-Iso SSR driver.
 *
 * Copyright (c) 2019 Future Electronics
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef NEO_ISO_DRV_H__
#define NEO_ISO_DRV_H__

#include "mbed.h"

namespace neoiso {

class NeoIso {
public:
    typedef enum {
        COMMAND_NO_OPERATION                            = 0,
        COMMAND_OFF_IMMEDIATE                           = 1,
        COMMAND_OFF_ZERO_CROSSING                       = 2,
        COMMAND_ON_IMMEDIATE                            = 3,
        COMMAND_ON_ZERO_CROSSING                        = 4,
        COMMAND_ON_IMMEDIATE_WITH_DITHERING             = 5,
        COMMAND_ON_ZERO_CROSSING_WITH_DITHERING         = 6,
        COMMAND_HEARTBEAT                               = 7,
        COMMAND_SET_POWER_TRANSFER_MODE                 = 8,
        COMMAND_CANCEL_POWER_TRANSFER_MODE              = 9,
        COMMAND_SET_INRUSH_MODE                         = 10,
        COMMAND_CANCEL_INRUSH_MODE                      = 11,
        COMMAND_START_A_LOAD_CURRENT_MEASURMENT         = 12,
        COMMAND_START_A_SYSTEM_VOLTAGE_MEASURMENT       = 13,
        COMMAND_START_A_SWITCH_TEMPERATURE_MEASURMENT   = 14,
        COMMAND_POOL_STATE                              = 15
    } command_t;

    typedef enum {
        PAGE_COMMAND        = 6,
        PAGE_CONFIGURATION  = 7
    } page_t;


public:
    NeoIso(PinName clk_pin, PinName data_pin, uint8_t address);

    ~NeoIso();

    int send_command(page_t page, command_t command);
    int get_status(uint8_t &status);

    int set_output(bool on);

    NeoIso& operator=(int value)
    {
        set_output(value != 0);
        return *this;
    }

    operator int()
    {
        return _on;
    }

protected:
    void _clear_buffer();
    void _buffer_put_bit(bool bit);
    int _send_buffer();

protected:
    static const size_t RESET_LENGTH = 3;
    static const size_t MAX_COMMAND_LENGTH = 34;

    typedef enum {
        BIT_RESET   = 0,
        BIT_ZERO    = 0xA000,
        BIT_ONE     = 0xAA00,
    } bit_value_t;

    mbed::SPI       _spi;
    uint8_t         _address;
    uint8_t         _on;
    uint32_t        _buffer_index;
    uint16_t        _tx_buffer[MAX_COMMAND_LENGTH];
    uint16_t        _rx_buffer[MAX_COMMAND_LENGTH];
};

}

#endif // NEO_ISO_DRV_H__
