

#ifndef TEST
#define TEST

#include "mbed.h"
#include "MMA8451Q.h"
#include "motor.h"

#define MMA8451_I2C_ADRESS (0x1d<<1)

#define FRQ_CLK 15000
#define FRQ_CYC 6000
#define AMIDTAB 64
#define BMIDTAB 63
#define BANDSIZE 4
#define MIN_INTE 0
#define MAX_INTE FRQ_CYC-500
#define INCREM_BALANCE 300
#define MARGE_LIGNE 5
#define MARGE_DISTANCE_LIGNE 10
#define LUMI_MOYENNE 80
#define CORRECTION_VIRAGE 1
#define MAX_BATTERY 1.3
#define SEUIL_NB_DERRIVEE 25
#define KD 600  //valeur de base 400
#define KI 3

#define BOSSE_ACTIVE S2

#define VITESSE 40
/***********************FONCTIONS**********************/
/**/     /****************CAMERA****************/   /**/
/**/    void F_GetData();                           /**/
/**/    void F_CLK();                               /**/
/**/    void Impulse_SI();                          /**/
/**/                                                /**/
/**/    /***************SHIELD*****************/    /**/
/**/    void moteurs_arriere();                     /**/
/**/    void test_servo(int time);                  /**/
/**/    void Get_pot_value();                       /**/
/**/                                                /**/
/**/    /**********TRAITEMENT_IMG************/      /**/
/**/    void F_TraitementImage();                   /**/
/**/    void F_BalanceBlancs();                     /**/
/**/    void Gestion_bosse();                       /**/
/**/    void T_image();                             /**/
/**/                                                /**/
/**/                                                /**/
/**/    /***********AUTRES_FCT***************/      /**/
/**/    char middle_3(char *tab);                   /**/
/**/    int middle_3U(int *tab);                    /**/
/**/    float middle_3F(float *tab);                /**/
/**/    void tri_a_bulle(char* t, int const size);  /**/
/**/    void tri_a_bulleU(int* t, int const size);  /**/
/**/    float tri_a_bulleF(float*t, int const size);/**/
/**/    unsigned char Moyenne(unsigned char *tab);  /**/
/**/    char Moyenne2(char *tab, int nb);           /**/
/**/    void menu();                                /**/
/**/    void init_bary();                           /**/
/**/    void fin_course();                          /**/   
/******************************************************/

/****************CAMERA****************/
extern DigitalOut SI;
extern DigitalOut CLK;
extern AnalogIn AIN;
extern unsigned char cam_data[128];
extern InterruptIn Int_clk;
extern char numero_data;
extern char clk_active;

/***************SHIELD*****************/
extern char bosse;
extern int ajust_vitesse;
extern int vitesse_virage;
extern DigitalOut BP1;
extern DigitalOut BP2;
extern DigitalOut led1;
extern DigitalOut led2;
extern DigitalOut led3;
extern DigitalOut led4;
extern DigitalIn S1;
extern DigitalIn S2;
extern DigitalIn S3;
extern DigitalIn S4;
extern AnalogIn pot1;
extern AnalogIn pot2;

/************TRAITEMENT_IMG************/
extern Ticker t_clk; 
extern Ticker t_finInte;
extern int tempsInte;
extern int baricentre;
extern char arrivee;
extern int somme_derivee;
extern int seuil_der;
extern float last_three[3];
extern int bary_tab[3];
extern int bary_tab_bis[3];
extern int integral;
extern int new_bari;
extern int ralentire;
extern MMA8451Q acc;
extern char last_five[5];

/*************AUTRES_VAR***************/
extern Ticker t_cyc; 
extern Serial pc;
extern Timer t_debut;
extern Timer t_ligne;
extern Timer timer;
extern int begin;
extern int VIT;
extern int KP;
extern int ligne_droite;











#endif /* !MLIB_H*/