#include "mbed.h"
#include "TFC.h"

int main()
{
    TFC_Init(); //Initiate TFC
    while(true) { //Loop start
        float i = TFC_ReadPot(0); //Read potentiometers (A value between -1 to 1)
        float v = (10*i + 10)/4; //Map value i to a range of 0 to 5
        TFC_SetBatteryLED_Level(v);
        if(TFC_PUSH_BUTTON_0_PRESSED) { //If button 0 is pressed, blink
            wait(0.5);
            TFC_SetBatteryLED_Level(0);
            wait(0.5);
        } //If end
    } //Loop end
} //Main end