#include "mbed.h"
#include "mcp4725.h"

/**
 * A test program for the MCP4725 DAC Library. This Test Application requires the following:
 *  * An MCP4725 connected to the I2C bus of the mbed LPC1768.
 *  * The analog out of the MCP1768 connected to Pin15 (analog in) of the mbed LPC1768.
 *  
 *
 * This is a stripped down version of the MCP4725_Library_Test found online, and should make the necessary commands more clear.
 * Last Edited: 12/24/13, Tim Brubaker
 *
 */

DigitalOut testLed(LED1);
Serial pc(USBTX, USBRX);
AnalogIn analogIn(p15);

// Class instantiation (similar to Serial pc(USBTX, USBRX) in function)
MCP4725 bacon(p9, p10, MCP4725::Fast400kHz, 0);
      

int main()
{
    // Print to terminal
    pc.printf("Ready.......FIGHT!\r\n");
    double freqf;
    double buffer [100];
    int cut = 0;
    
    // if statement
    //freqf = 0.5;
    freqf = 0.05;
    
    while( cut < 100){
        buffer[ cut ] = sin( 2 * 3.1415926 * cut / 100);
        cut++;
        }
        
 
  
    while(1) {
        /*
        testLed = 1;
        wait(freqf);
        // Write to DAC register (not EEPROM). Documentation in library files.
        bacon.write(MCP4725::Normal, (0xFFF * (1.0/3.32) ), false);
        testLed = 0;
        pc.printf("Value is %f V \r\n",analogIn.read()*3.3);
        wait(freqf);
        bacon.write(MCP4725::Normal, (0x000 * (1.0/3.3) ), false);
        */
        
        
        
        testLed = 1;
        
        if ( cut == 100)
        {
            cut = 0;
        }
        
        bacon.write(MCP4725::Normal, (buffer[cut] * 0xFFF * (1.0/3.32) ), false);
        cut++;
        
        wait(freqf/100);
        
        // Print ADC measurement to terminal. Scale factor of 3.3 needed for internal ADC.
        pc.printf("Value is %f V \r\n",analogIn.read()*3.3);

    }
}