/*** Thread: CAN ***
 * Test CAN to controller
 *TODO
 *2 Ints samenvoegen zodat we naar het juiste register kunnen sturen, register is fixed, de waardes voor de controller zijn afhankelijk van een sensor.
 */
#include "mbed.h"
#include "CAN.h"
#include <string>
/* CAN (RD TD) */
CAN can(PA_11, PA_12);

DigitalOut canEN(PA_10);
/* Heartbeat */
DigitalOut led(LED1);
 
/* Structures to help pack and unpack the 8 CAN data bytes */
typedef struct bytes_64 {
    uint8_t b0;
    uint8_t b1;
    uint8_t b2;
    uint8_t b3;
    uint8_t b4;
    uint8_t b5;
    uint8_t b6;
    uint8_t b7;
} bytes_64;
 
typedef union {
    uint64_t data;
    bytes_64 bytes;
} data_packed;
 
 
/* main */
int main() {
    
    printf("\r\n---Start---\r\n");
 
    data_packed send_data;      //struct for send message
    data_packed receive_data;   //struct for rcv message
    CANMessage msg;             //message object for rcv
    int send_id = 513;                                       //Id motorcontroller   0x201 -> 513
    int send_status = 0;
    
    canEN = 0;                                              //Voor de tranceiver
    
    //send_data.data = 0x0CCD31;                              //0CCD snelheid motor, 31 register in controller.             WERKT
    send_data.data = 0;
    can.frequency(1000000);                                 //1m freq
    can.mode(CAN::LocalTest);
    //can.mode(CAN::Normal);                                //1vd2 comment
    /* Loop */
    int x = 0x0CCD;
    int y = 0x31;
    int xshifted;
    int xy; 
    
    //shiften en optellen
    xshifted = x << 8;
    xy = xshifted + y;
      
    
    /*/////////////////////////////////////////////////////////////
    int Result;
    Result = a[5];
    Result = Result << 8;
    Result = Result | b[2];
    *//////////////////////////////////////////////////////////////
    
    unsigned pow = 10;
    while(y >= pow)
        pow *= 10;
    send_data.data = x * pow + y;
    
    while (true) {
 
        send_status = can.write(CANMessage(send_id, (char*) &send_data, 3));
 
        if (send_status == true) {
            //send_data.data = send_data.data + 1;
            
        }
 
        /* Receive */
        if (can.read(msg)) {
            //move message bytes to receive, so we can access as a uint64_t (u long long)
            receive_data.bytes.b7 = msg.data[7];
            receive_data.bytes.b6 = msg.data[6];
            receive_data.bytes.b5 = msg.data[5];
            receive_data.bytes.b4 = msg.data[4];
            receive_data.bytes.b3 = msg.data[3];
            receive_data.bytes.b2 = msg.data[2];
            receive_data.bytes.b1 = msg.data[1];
            receive_data.bytes.b0 = msg.data[0];
 
            printf("Message received ID,Msg: %d, %llu\r\n", msg.id, receive_data.data);
        }
 
        /* Heartbeat */
        led = !led;
 
        wait(0.5);
    } //while
}