/*** Thread: CAN ***
 * Test CAN to controller
 *
 */
#include "mbed.h"
#include "CAN.h"
#include <string>
/* CAN (RD TD) */
CAN can(PA_11, PA_12);

DigitalOut canEN(PA_10);

DigitalIn safety(PB_1);
DigitalOut buzzer(PB_0);

AnalogIn analog_value(PA_0);

 
/* Structures to help pack and unpack the 8 CAN data bytes */
typedef struct bytes_64 {
    uint8_t b0;
    uint8_t b1;
    uint8_t b2;
    uint8_t b3;
    uint8_t b4;
    uint8_t b5;
    uint8_t b6;
    uint8_t b7;
} bytes_64;
 
typedef union {
    uint64_t data;
    bytes_64 bytes;
} data_packed;
 
int send_id = 513;     
data_packed send_data;
int reg = 0x31;                                                                                                   //Id motorcontroller   0x201 -> 513                                                                                                               //Voor moving average te berekenen
    
    
long map(long x, long in_min, long in_max, long out_min, long out_max)                                                      //MAP functie voor verschalingen.
{
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}


void MOTOR_Calculate_Power(int speed)
{
   
    send_data.data = (speed << 8) + reg;                                                                       //shiften en optellen
    can.write(CANMessage(send_id, (char*) &send_data, 3));
}
 
int main() {
    
    printf("\r\n---Start---\r\n");
 
    data_packed send_data;                                                                                                  //struct for send message
    data_packed receive_data;                                                                                               //struct for rcv message
    CANMessage msg;                                                                                                         //message object for rcv
    int send_id = 513;                                                                                                      //Id motorcontroller   0x201 -> 513                                                                                                               //Voor moving average te berekenen
    canEN = 0;                                                                                                              //Voor de tranceiver
    
    //send_data.data = 0x0CCD31;                                                                                            //0CCD snelheid motor, 31 register in controller.             WERKT
    send_data.data = 0;
    can.frequency(1000000);                                                                                                 //1m freq
    can.mode(CAN::LocalTest);
    //can.mode(CAN::Normal);                                                                                                //1vd2 comment
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    int speed = 0;                                                                                                          //Snelheid naar de motor
    int reg = 0x31;                                                                                                         //register in de controller
    float meas_r;
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    while (true) {
        meas_r = analog_value.read() * 100;
        speed = map(meas_r, 0, 100, 0, 0x7FFF);                                                                             //waarde schommelt niet
        
               
        MOTOR_Calculate_Power(speed);
        
        
 
       
 
        /* Receive */
        if (can.read(msg)) {
            //move message bytes to receive, so we can access as a uint64_t (u long long)
            receive_data.bytes.b7 = msg.data[7];
            receive_data.bytes.b6 = msg.data[6];
            receive_data.bytes.b5 = msg.data[5];
            receive_data.bytes.b4 = msg.data[4];
            receive_data.bytes.b3 = msg.data[3];
            receive_data.bytes.b2 = msg.data[2];
            receive_data.bytes.b1 = msg.data[1];
            receive_data.bytes.b0 = msg.data[0];
 
            printf("Message received ID,Msg: %d, %llu\r\n", msg.id, receive_data.data);
        }
        wait(0.5);
    } 
}