//#if !FEATURE_LWIP
//    #error [NOT_SUPPORTED] LWIP not supported for this target
//#endif

// ref
// https://os.mbed.com/questions/76794/How-to-set-Static-IP-address-with-Nucleo/
// https://os.mbed.com/docs/mbed-os/v5.11/apis/ethernet.html
#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"

#define HTTP_STATUS_LINE "HTTP/1.0 200 OK"
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8"
#define HTTP_MESSAGE_BODY ""                                     \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1>Hello World</h1>" "\r\n"                              \
"      <p>Finally It works !</p>" "\r\n"                                 \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"

#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"


Serial pc(SERIAL_TX, SERIAL_RX);
int main()
{
    pc.baud(57600);

    pc.printf("Basic HTTP server example\r\n");

    EthernetInterface eth;
    eth.set_network("192.168.1.11","255.255.252.0","192.168.1.10");
    //eth.set_network(IP_Adress,GATEWAY,MASK);
    eth.connect();

    pc.printf("The target IP address is '%s'\r\n", eth.get_ip_address());

    TCPServer srv;
    TCPSocket clt_sock;
    SocketAddress clt_addr;

    /* Open the server on ethernet stack */
    srv.open(&eth);

    /* Bind the HTTP port (TCP 22) to the server */
    srv.bind(eth.get_ip_address(), 80);

    /* Can handle 5 simultaneous connections */
    srv.listen(5);

    char buffer[300];

    while (true) {
        srv.accept(&clt_sock, &clt_addr);
        pc.printf("accept %s:%d\r\n", clt_addr.get_ip_address(), clt_addr.get_port());
        clt_sock.send(HTTP_RESPONSE, strlen(HTTP_RESPONSE));
        
        // example to move messages between uart and tcp / ip socket
        while (0) {
            if (1) {
                while (pc.readable()) {
                    char c = pc.getc(); // Read hyperterminal
                    buffer[0] = c;
                    clt_sock.send(buffer, 1);
                    //echo
                    pc.printf("%c", c);
                }
            } else {
                // blocking mode
                int recdata = clt_sock.recv(buffer,300);
                if (recdata >0 ){
                    buffer[recdata]=0;
                    printf("%s %d\r\n", buffer, recdata);
                    // echo
                    buffer[recdata]=10;
                    buffer[recdata+1]=13;
                    clt_sock.send(buffer, recdata+2);
                }
            }
        }

    }
}
