#include "mbed.h"
#include "MQ2.h"

Serial pc(USBTX, USBRX); // tx, rx
MQ2 mq2(A1);                                                                    // Analog Port to read from

int main() {
    pc.baud(115200);
    mq2.begin();                                                                // 'Calibrate' sensor
    MQ2_data_t MQ2_data;                                                        // Structure to hold data.
    while (true) {
        pc.printf("CO PPM: %.0f\r\n",mq2.readCO());                             // Performs a one shot read of CO
        pc.printf("Smoke PPM: %.0f\r\n",mq2.readSmoke());                       // Performs a one shot read of Smoke
        pc.printf("LPG PPM: %.0f\r\n",mq2.readLPG());                           // Performs a one shot read of LPG
        wait(1);
        pc.printf("................................\r\n");                      
        mq2.read(&MQ2_data);                                                    // Alt reading method, reading to struct
        pc.printf("CO PPM: %.0f\r\n",MQ2_data.co);                              // Return data from strut
        pc.printf("Smoke PPM: %.0f\r\n",MQ2_data.smoke);                        // Return data from strut
        pc.printf("LPG PPM: %.0f\r\n",MQ2_data.lpg);                            // Return data from strut
        pc.printf("................................\r\n");
        pc.printf("E' caldo\r\n");                      
        wait(1);
    }
}

