/* Variables -----------------------------------------------------------------*/

/* Initialization parameters of the motor connected to the expansion board. */
/* Voltage mode. */
powerstep01_init_u_t init =
{
  /* common parameters */
  .cm.cp.cmVmSelection = POWERSTEP01_CM_VM_CURRENT, // enum powerstep01_CmVm_t
  //.cm.cp.cmVmSelection = POWERSTEP01_CM_VM_VOLTAGE, // enum powerstep01_CmVm_t
  500, // Acceleration rate in step/s2, range 14.55 to 59590 steps/s^2 582
  500, // Deceleration rate in step/s2, range 14.55 to 59590 steps/s^2 582
  122.00, // Maximum speed in step/s, range 15.25 to 15610 steps/s 488 92.45 180.45
  1.0, // Minimum speed in step/s, range 0 to 976.3 steps/s
  POWERSTEP01_LSPD_OPT_ON, // Low speed optimization bit, enum powerstep01_LspdOpt_t
  15624.00, // Full step speed in step/s, range 7.63 to 15625 steps/s 244.16
  POWERSTEP01_BOOST_MODE_OFF, // Boost of the amplitude square wave, enum powerstep01_BoostMode_t
  968.75, // Overcurrent threshold settings via enum powerstep01_OcdTh_t 281.25
  STEP_MODE_1_8, // Step mode settings via enum motorStepMode_t
  POWERSTEP01_SYNC_SEL_DISABLED, // Synch. Mode settings via enum powerstep01_SyncSel_t
   (POWERSTEP01_ALARM_EN_OVERCURRENT|
   POWERSTEP01_ALARM_EN_THERMAL_SHUTDOWN|
   POWERSTEP01_ALARM_EN_THERMAL_WARNING|
   POWERSTEP01_ALARM_EN_UVLO|
   POWERSTEP01_ALARM_EN_STALL_DETECTION|
   POWERSTEP01_ALARM_EN_SW_TURN_ON|
   POWERSTEP01_ALARM_EN_WRONG_NPERF_CMD), // Alarm settings via bitmap enum powerstep01_AlarmEn_t
  POWERSTEP01_IGATE_64mA, // Gate sink/source current via enum powerstep01_Igate_t  64
  POWERSTEP01_TBOOST_0ns, // Duration of the overboost phase during gate turn-off via enum powerstep01_Tboost_t
  POWERSTEP01_TCC_500ns, // Controlled current time via enum powerstep01_Tcc_t 500
  POWERSTEP01_WD_EN_DISABLE, // External clock watchdog, enum powerstep01_WdEn_t  
  POWERSTEP01_TBLANK_375ns, // Duration of the blanking time via enum powerstep01_TBlank_t 375
  POWERSTEP01_TDT_125ns, // Duration of the dead time via enum powerstep01_Tdt_t 125
  #if defined(provaStepper)
      93.60, // KVAL Hold torque in mV, range from 0.0mV to 0.996 mV 
      233.00, // KVAL RUN torque in mV, range from 0.0mV to 0.996 mV 
      233.00, // KVAL ACC torque in mV, range from 0.0mV to 0.996 mV 
      233.00, // KVAL DEC torque in mV, range from 0.0mV to 0.996 mV 
  #else
      93.60, // KVAL Hold torque in mV, range from 0.0mV to 0.996 mV 
      273.00, // KVAL RUN torque in mV, range from 0.0mV to 0.996 mV 
      273.00, // KVAL ACC torque in mV, range from 0.0mV to 0.996 mV 
      273.00, // KVAL DEC torque in mV, range from 0.0mV to 0.996 mV 
  #endif
  POWERSTEP01_TOFF_FAST_28us, //Maximum fast decay time , enum powerstep01_ToffFast_t 8
  POWERSTEP01_FAST_STEP_28us, //Maximum fall step time , enum powerstep01_FastStep_t 12
  3.0, // Minimum on-time in us, range 0.5us to 64us 3.0
  20.5, // Minimum off-time in us, range 0.5us to 64us 21.0
  POWERSTEP01_CONFIG_INT_16MHZ_OSCOUT_2MHZ, // Clock setting , enum powerstep01_ConfigOscMgmt_t
  POWERSTEP01_CONFIG_SW_HARD_STOP, // External switch hard stop interrupt mode, enum powerstep01_ConfigSwMode_t
  POWERSTEP01_CONFIG_TQ_REG_TVAL_USED, // External torque regulation enabling , enum powerstep01_ConfigEnTqReg_t
  POWERSTEP01_CONFIG_VS_COMP_ENABLE, // Motor Supply Voltage Compensation enabling , enum powerstep01_ConfigEnVscomp_t 
  POWERSTEP01_CONFIG_OC_SD_DISABLE, // Over current shutwdown enabling, enum powerstep01_ConfigOcSd_t
  POWERSTEP01_CONFIG_UVLOVAL_LOW, // UVLO Threshold via powerstep01_ConfigUvLoVal_t
  POWERSTEP01_CONFIG_VCCVAL_7_5V, // VCC Val, enum powerstep01_ConfigVccVal_t
  POWERSTEP01_CONFIG_TSW_124us, // Switching period, enum powerstep01_ConfigTsw_t 048
  POWERSTEP01_CONFIG_PRED_ENABLE // Predictive current enabling , enum powerstep01_ConfigPredEn_t 
};
/* Motor Control Component. */
PowerStep01 *motor;
