
Watchdog wd;
#if defined(runner)
    #if defined(speedMaster)
        InterruptIn tractorSpeedRead(PB_1);         // define interrupt pin for tractor speed calculation MASTER MODE
        DigitalOut quinconceOut(PC_9);              // sincro per quinconcio out
    #else
        InterruptIn tractorSpeedRead(PC_5);         // define interrupt pin for tractor speed calculation SLAVE MODE
        InterruptIn quinconceIn(PA_9);
        DigitalIn quinconceOut(PC_9,PullUp);        // sincro per quinconcio out
    #endif
    
    InterruptIn DcEncoder(PB_2);                // define input for reading speed of seed wheel with fixed 25 hole
    InterruptIn seedCheck(PC_6);                      // define input for reading seed passage to picks
    InterruptIn pwmCheck(PB_13);
    
    DigitalOut speedClock(PC_8);                // define out for speed clock repeater
    DigitalIn TBzeroPinInputRev(PB_11);             // define input of reading zero position of distributor wheel
    DigitalIn seedWheelZeroPinInputRev(PB_12);      // define input of reading zero position of seeding wheel
    DigitalIn seedLevel(PB_0);                      // define input for reading seed level on tank
    DigitalIn buttonUser(PC_13);                    // pulsante su scheda
    
    
    PwmOut SDmotorPWM(PB_13);                       // define frequency command for seeding whell motor driver
    DigitalOut SDmotorInB(PB_14);                   // sd motor half bridge direction selector
    DigitalOut SDmotorInA(PB_15);                   // SD motor half bridge direction selector
    DigitalIn enDiag_A(PB_5);                       // SD motor fault condition input A
    DigitalIn enDiag_B(PB_4);                       // SD motor fault condition input A
    AnalogIn SDcurrent(PA_4);                       // SD power current feedback
    
    //DigitalOut TBmotor_CS(PB_6);                    // PowerStep01 SPI ChipSelect
    //DigitalOut TBmotor_CK(PA_5);                    // PowerStep01 SPI Clock
    //DigitalOut TBmotor_SDI(PA_7);                   // PowerStep01 Serial Data Input MOSI sulla cpu
    //DigitalOut TBmotor_SDO(PA_6);                   // PowerStep01 Serial Data Output MISO sulla cpu
    //DigitalIn TBmotor_Busy(PC_7);                   // PowerStep01 Driver busy
    //DigitalIn TBmotor_Flag(PA_8);                   // PowerStep01 Driver Flag
    DigitalOut TBmotorStepOut(PB_3);                // PowerStep01 Step Input
    DigitalOut TBmotor_SW(PB_10);                   // PowerStep01 Switch
    DigitalOut TBmotorRst(PC_4);                    // PowerStep01 Driver reset
    int TBmotorDirecti;             
    //DigitalOut passo(PB_3);
    //DigitalOut led(LED1);
    //DigitalOut cs1(PB_6);
    
    
    
    #if defined(canbusActive)
        CAN can1(PA_11,PA_12,100000);           // CAN BUS channel for communication with other slave and master consolle
        int checkState=0;
    #endif
    //CANMessage txMsg;
    CANMessage rxMsg;
    
    #if defined(pcSerial)
        Serial pc(USBTX, USBRX,230400);         // serial channel for PC communication
    #endif
#endif

#if defined(oldStepperDriver)

    #if defined(speedMaster)
        InterruptIn tractorSpeedRead(PB_1);         // define interrupt pin for tractor speed calculation MASTER MODE
        DigitalOut quinconceOut(PA_5);              // sincro per quinconcio out
        DigitalOut speedClock(PA_6);                // define out for speed clock repeater
        InterruptIn DcEncoder(PB_2);                // define input for reading speed of seed wheel with fixed 25 hole
    #else
        InterruptIn tractorSpeedRead(PB_6);         // define interrupt pin for tractor speed calculation SLAVE MODE
        InterruptIn quinconceIn(PA_9);
        DigitalIn quinconceOut(PA_5,PullUp);        // sincro per quinconcio out
        InterruptIn DcEncoder(PB_2);                // define input for reading speed of seed wheel with fixed 25 hole
        DigitalOut speedClock(PA_6);                // define out for speed clock repeater
        DigitalIn seedLevel(PB_1);                      // define input for reading seed level on tank
    #endif
    
    DigitalIn TBzeroPinInputRev(PB_11);             // define input of reading zero position of distributor wheel
    DigitalIn seedWheelZeroPinInputRev(PB_12);      // define input of reading zero position of seeding wheel
    InterruptIn seedCheck(PA_7);                      // define input for reading seed passage to picks
    DigitalIn buttonUser(PC_13);                    // pulsante su scheda
    
    
    InterruptIn pwmCheck(PB_13);
    PwmOut SDmotorPWM(PB_13);                       // define frequency command for seeding whell motor driver
    DigitalOut SDmotorInB(PB_14);                   // sd motor half bridge direction selector
    DigitalOut SDmotorInA(PB_15);                   // SD motor half bridge direction selector
    DigitalIn enDiag_A(PB_5);                       // SD motor fault condition input A
    DigitalIn enDiag_B(PB_4);                       // SD motor fault condition input A
    AnalogIn SDcurrent(PA_4);                       // SD power current feedback
    
    DigitalOut TBmotor_M1(PC_8);                    // TB motor step division M1
    DigitalOut TBmotor_M2(PC_6);                    // TB motor step division M2
    DigitalOut TBmotor_M3(PC_5);                    // TB motor step division M3
    DigitalOut TBmotorRst(PC_4);                    // TB motor driver reset
    DigitalOut TBmotorStepOut(PB_3);                // TB motor step command
    DigitalOut TBmotorDirecti(PA_10);               // TB motor direction command
    
    /*
    #if defined(speedMaster)
        //DigitalOut led(LED1);                           // ATTENZIONE: LED1 E' SU PA5 / D13
    #else
        DigitalOut led(PC_7);                           // ATTENZIONE: LED1 E' SU PA5 / D13
    #endif
    */
    
    //DigitalIn zeroRequestIn(PB_6);          // define input of zero request for slave module
    //DigitalIn runRequestIn(PB_9);           // define input of run request for slave module
    
    #if defined(canbusActive)
        CAN can1(PA_11,PA_12,100000);           // CAN BUS channel for communication with other slave and master consolle
        int checkState=0;
    #endif
    CANMessage txMsg;
    CANMessage rxMsg;
    
    #if defined(pcSerial)
        Serial pc(USBTX, USBRX,250000);         // serial channel for PC communication
    #else
        #if defined(speedTime)
            Serial pc(USBTX, USBRX,250000);         // serial channel for PC communication
        #endif
    #endif

#endif