#include "mbed.h"
#include "nRF24L01P_PTX.h"
#include "nRF24L01P_PRX.h"
 /*#VCC p3
#GND GND
#CSN D10
#CE PTC11
#MOSI D9
#SCK PTD1
#IRQ PTD0
#MISO D3*/
int main()
{
   nRF24L01P Device(D9, D3, PTD1, D10);
 
   nRF24L01P_PTX PTX(Device, PTC11, PTD0);
 
   PTX.Initialize();
   PTX.SetDataRate(2000);
   PTX.PowerUp();
 
 
   nRF24L01P Receiver(PTD2, PTD3, PTD1, PTC7);
   nRF24L01P_PRX PRX(Receiver, PTC11, PTD0);
 
   printf("Initialize\r\n");
   PRX.Initialize();
   printf("SetDataRate\r\n");
   PRX.SetDataRate(2000);
   printf("SetPayloadSize\r\n");
   PRX.SetPayloadSize(1);
   printf("PowerUp\r\n");
   PRX.PowerUp();
   printf("StartReceive\r\n");
   PRX.StartReceive();
   printf("Loop\r\n");
   
   while (1)
   {
      char c = 'a';
      printf("Transmit\r\n");
      int r = PTX.TransmitPacket(&c, 1);
      printf("%d\r\n", r);
      
      if (PRX.IsPacketReady())
      {
         char d;
         int r = PRX.ReadPacket(&d);
         printf("Read %d %c\r\n", r, d);
      }
      
      wait_us(1000);
   }
}