#include "pH_Sensor.h"

/* Function: disableContinuousMode
 * -------------------------------
 * The pH sensor initially reads continuously. Changes
 * to single reading format.
 */
void pH_Sensor::disableContinuousMode() {
    printf("pH sensor will NOT run in continous mode.\n");
    if(pH_Serial.writeable() <= 0) printf("Not writable\n");
    // disable continuous mode
    pH_Serial.printf("C,0");
    pH_Serial.printf("%c", '\r');
    printf("Waiting five seconds... ");
    wait(5);
}

/* Function: setup
 * ---------------
 * Initially sets up the pH sensor by setting the baud
 * rate and disabling the continous mode.
 */
void pH_Sensor::setup() {
    pH_Serial.baud(PH_BAUD);
    disableContinuousMode();
}

/* Function: request
 * -----------------
 * Sends a request to the pH sensor asking for a reading.
 */
void pH_Sensor::request() {
    printf("Sending pH request...\n");
    if(pH_Serial.writeable() <= 0) printf("Not writable\n");
    // request one reading
    pH_Serial.printf("R");
    pH_Serial.printf("%c", '\r');
}

/* Function: read
 * --------------
 * Requests a reading and parses the recieved data
 * to construct and return a float.
 */
float pH_Sensor::read() {
    float pH = 0.0;
    request();
    printf("Reading pH information.\n");
    if (pH_Serial.readable() > 0) {                     //if we see that the Atlas Scientific product has sent a character.
        string sensorstring = "";
        printf("Receiving sensor string... [");
        char inchar;
        while((inchar = (char)pH_Serial.getc()) != '\r') {
            sensorstring += inchar;
            printf("%c", inchar);
        }
        printf("] ...sensor string received!\n");
        printf(sensorstring.c_str());
        // +1 is to get rid of control character
        pH = atof(sensorstring.c_str()+1);                      //convert the string to a floating point number so it can be evaluated by the Arduino

        if (pH >= 7.0) {                                  //if the pH is greater than or equal to 7.0
            printf("high\n");                         //print "high" this is demonstrating that the Arduino is evaluating the pH as a number and not as a string
        }
        else {                                //if the pH is less than or equal to 6.999
            printf("low\n");                          //print "low" this is demonstrating that the Arduino is evaluating the pH as a number and not as a string
        }
    } else {
        printf("pH sensor is not readable\n");
    }
    return pH;
}