#include "mbed.h"
#include <string>

Serial pc (USBTX, USBRX);
Serial ph_Serial (D8,D2); //serial object for use w/ GPS

string inputstring = "";
string sensorstring = "";
char input_string_complete = 0;
char sensor_string_complete = 0;
bool input_stringcomplete = false;
bool sensor_stringcomplete = false;
float pH;

void setup()
{
    printf("Setup\n");
    pc.baud(9600);
    ph_Serial.baud(9600);
}

int main()
{
    setup();
    char c = pc.getc();
    inputstring = "c";
    printf("%c\n", c);
    input_stringcomplete = true;
    while(true) {
        if (input_stringcomplete) {                         //if a string from the PC has been received in its entirety
            printf("Hit input_stringcomplete\n");
            printf("%s\n", inputstring.c_str());
            if(ph_Serial.writeable() <= 0) printf("Not writable\n");
            //ph_Serial.putc('C');
            //ph_Serial.putc(',');
            //ph_Serial.putc('0');
            //ph_Serial.send_break();                           //send that string to the Atlas Scientific product
            //printf("Sent\n");
            //for(int i = 0; i < 100; i++){
                ph_Serial.printf("C,0");
                ph_Serial.printf("%c", '\r');
                wait(5);
                ph_Serial.printf("R");
                ph_Serial.printf("%c", '\r');
                
            //}
            
            //ph_Serial.send_break();
            printf("Sent\n");
            inputstring = "";                                 //clear the string
            input_stringcomplete = false;                     //reset the flag used to tell if we have received a completed string from the PC
        }

        if (ph_Serial.readable() > 0) {                     //if we see that the Atlas Scientific product has sent a character.
            printf("serial readable hit\n");
            char inchar;
            while((inchar = (char)ph_Serial.getc()) != '\r'){
                sensorstring += inchar;
            }
            printf("%s\n", sensorstring.c_str());
            sensor_stringcomplete = true;
        }


        if (sensor_stringcomplete) { 
            printf("Sensorstring\n");                       //if a string from the Atlas Scientific product has been received in its entirety
            printf("%s\n", sensorstring.c_str());                     //send that string to the PC's serial monitor
            pH = atof(sensorstring.c_str());                      //convert the string to a floating point number so it can be evaluated by the Arduino

            if (pH >= 7.0) {                                  //if the pH is greater than or equal to 7.0
                printf("high");                         //print "high" this is demonstrating that the Arduino is evaluating the pH as a number and not as a string
            }

            if (pH <= 6.999) {                                //if the pH is less than or equal to 6.999
                printf("low");                          //print "low" this is demonstrating that the Arduino is evaluating the pH as a number and not as a string
            }
            
            ph_Serial.printf("SLEEP");
            ph_Serial.printf("%c", '\r');

            sensorstring = "";                                //clear the string:
            sensor_stringcomplete = false;                    //reset the flag used to tell if we have received a completed string from the Atlas Scientific product
        }
    }
}
