/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_RNG_REGISTERS_H__
#define __HW_RNG_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 RNG
 *
 * Random Number Generator Accelerator
 *
 * Registers defined in this header file:
 * - HW_RNG_CR - RNGA Control Register
 * - HW_RNG_SR - RNGA Status Register
 * - HW_RNG_ER - RNGA Entropy Register
 * - HW_RNG_OR - RNGA Output Register
 *
 * - hw_rng_t - Struct containing all module registers.
 */

#define HW_RNG_INSTANCE_COUNT (1U) /*!< Number of instances of the RNG module. */

/*******************************************************************************
 * HW_RNG_CR - RNGA Control Register
 ******************************************************************************/

/*!
 * @brief HW_RNG_CR - RNGA Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * Controls the operation of RNGA.
 */
typedef union _hw_rng_cr
{
    uint32_t U;
    struct _hw_rng_cr_bitfields
    {
        uint32_t GO : 1;               /*!< [0] Go */
        uint32_t HA : 1;               /*!< [1] High Assurance */
        uint32_t INTM : 1;             /*!< [2] Interrupt Mask */
        uint32_t CLRI : 1;             /*!< [3] Clear Interrupt */
        uint32_t SLP : 1;              /*!< [4] Sleep */
        uint32_t RESERVED0 : 27;       /*!< [31:5]  */
    } B;
} hw_rng_cr_t;

/*!
 * @name Constants and macros for entire RNG_CR register
 */
/*@{*/
#define HW_RNG_CR_ADDR(x)        ((x) + 0x0U)

#define HW_RNG_CR(x)             (*(__IO hw_rng_cr_t *) HW_RNG_CR_ADDR(x))
#define HW_RNG_CR_RD(x)          (HW_RNG_CR(x).U)
#define HW_RNG_CR_WR(x, v)       (HW_RNG_CR(x).U = (v))
#define HW_RNG_CR_SET(x, v)      (HW_RNG_CR_WR(x, HW_RNG_CR_RD(x) |  (v)))
#define HW_RNG_CR_CLR(x, v)      (HW_RNG_CR_WR(x, HW_RNG_CR_RD(x) & ~(v)))
#define HW_RNG_CR_TOG(x, v)      (HW_RNG_CR_WR(x, HW_RNG_CR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual RNG_CR bitfields
 */

/*!
 * @name Register RNG_CR, field GO[0] (RW)
 *
 * Specifies whether random-data generation and loading (into OR[RANDOUT]) is
 * enabled.This field is sticky. You must reset RNGA to stop RNGA from loading
 * OR[RANDOUT] with data.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
/*@{*/
#define BP_RNG_CR_GO         (0U)          /*!< Bit position for RNG_CR_GO. */
#define BM_RNG_CR_GO         (0x00000001U) /*!< Bit mask for RNG_CR_GO. */
#define BS_RNG_CR_GO         (1U)          /*!< Bit field size in bits for RNG_CR_GO. */

/*! @brief Read current value of the RNG_CR_GO field. */
#define BR_RNG_CR_GO(x)      (BITBAND_ACCESS32(HW_RNG_CR_ADDR(x), BP_RNG_CR_GO))

/*! @brief Format value for bitfield RNG_CR_GO. */
#define BF_RNG_CR_GO(v)      ((uint32_t)((uint32_t)(v) << BP_RNG_CR_GO) & BM_RNG_CR_GO)

/*! @brief Set the GO field to a new value. */
#define BW_RNG_CR_GO(x, v)   (BITBAND_ACCESS32(HW_RNG_CR_ADDR(x), BP_RNG_CR_GO) = (v))
/*@}*/

/*!
 * @name Register RNG_CR, field HA[1] (RW)
 *
 * Enables notification of security violations (via SR[SECV]). A security
 * violation occurs when you read OR[RANDOUT] and SR[OREG_LVL]=0. This field is sticky.
 * After enabling notification of security violations, you must reset RNGA to
 * disable them again.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
/*@{*/
#define BP_RNG_CR_HA         (1U)          /*!< Bit position for RNG_CR_HA. */
#define BM_RNG_CR_HA         (0x00000002U) /*!< Bit mask for RNG_CR_HA. */
#define BS_RNG_CR_HA         (1U)          /*!< Bit field size in bits for RNG_CR_HA. */

/*! @brief Read current value of the RNG_CR_HA field. */
#define BR_RNG_CR_HA(x)      (BITBAND_ACCESS32(HW_RNG_CR_ADDR(x), BP_RNG_CR_HA))

/*! @brief Format value for bitfield RNG_CR_HA. */
#define BF_RNG_CR_HA(v)      ((uint32_t)((uint32_t)(v) << BP_RNG_CR_HA) & BM_RNG_CR_HA)

/*! @brief Set the HA field to a new value. */
#define BW_RNG_CR_HA(x, v)   (BITBAND_ACCESS32(HW_RNG_CR_ADDR(x), BP_RNG_CR_HA) = (v))
/*@}*/

/*!
 * @name Register RNG_CR, field INTM[2] (RW)
 *
 * Masks the triggering of an error interrupt to the interrupt controller when
 * an OR underflow condition occurs. An OR underflow condition occurs when you
 * read OR[RANDOUT] and SR[OREG_LVL]=0. See the Output Register (OR) description.
 *
 * Values:
 * - 0 - Not masked
 * - 1 - Masked
 */
/*@{*/
#define BP_RNG_CR_INTM       (2U)          /*!< Bit position for RNG_CR_INTM. */
#define BM_RNG_CR_INTM       (0x00000004U) /*!< Bit mask for RNG_CR_INTM. */
#define BS_RNG_CR_INTM       (1U)          /*!< Bit field size in bits for RNG_CR_INTM. */

/*! @brief Read current value of the RNG_CR_INTM field. */
#define BR_RNG_CR_INTM(x)    (BITBAND_ACCESS32(HW_RNG_CR_ADDR(x), BP_RNG_CR_INTM))

/*! @brief Format value for bitfield RNG_CR_INTM. */
#define BF_RNG_CR_INTM(v)    ((uint32_t)((uint32_t)(v) << BP_RNG_CR_INTM) & BM_RNG_CR_INTM)

/*! @brief Set the INTM field to a new value. */
#define BW_RNG_CR_INTM(x, v) (BITBAND_ACCESS32(HW_RNG_CR_ADDR(x), BP_RNG_CR_INTM) = (v))
/*@}*/

/*!
 * @name Register RNG_CR, field CLRI[3] (WORZ)
 *
 * Clears the interrupt by resetting the error-interrupt indicator (SR[ERRI]).
 *
 * Values:
 * - 0 - Do not clear the interrupt.
 * - 1 - Clear the interrupt. When you write 1 to this field, RNGA then resets
 *     the error-interrupt indicator (SR[ERRI]). This bit always reads as 0.
 */
/*@{*/
#define BP_RNG_CR_CLRI       (3U)          /*!< Bit position for RNG_CR_CLRI. */
#define BM_RNG_CR_CLRI       (0x00000008U) /*!< Bit mask for RNG_CR_CLRI. */
#define BS_RNG_CR_CLRI       (1U)          /*!< Bit field size in bits for RNG_CR_CLRI. */

/*! @brief Format value for bitfield RNG_CR_CLRI. */
#define BF_RNG_CR_CLRI(v)    ((uint32_t)((uint32_t)(v) << BP_RNG_CR_CLRI) & BM_RNG_CR_CLRI)

/*! @brief Set the CLRI field to a new value. */
#define BW_RNG_CR_CLRI(x, v) (BITBAND_ACCESS32(HW_RNG_CR_ADDR(x), BP_RNG_CR_CLRI) = (v))
/*@}*/

/*!
 * @name Register RNG_CR, field SLP[4] (RW)
 *
 * Specifies whether RNGA is in Sleep or Normal mode. You can also enter Sleep
 * mode by asserting the DOZE signal.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Sleep (low-power) mode
 */
/*@{*/
#define BP_RNG_CR_SLP        (4U)          /*!< Bit position for RNG_CR_SLP. */
#define BM_RNG_CR_SLP        (0x00000010U) /*!< Bit mask for RNG_CR_SLP. */
#define BS_RNG_CR_SLP        (1U)          /*!< Bit field size in bits for RNG_CR_SLP. */

/*! @brief Read current value of the RNG_CR_SLP field. */
#define BR_RNG_CR_SLP(x)     (BITBAND_ACCESS32(HW_RNG_CR_ADDR(x), BP_RNG_CR_SLP))

/*! @brief Format value for bitfield RNG_CR_SLP. */
#define BF_RNG_CR_SLP(v)     ((uint32_t)((uint32_t)(v) << BP_RNG_CR_SLP) & BM_RNG_CR_SLP)

/*! @brief Set the SLP field to a new value. */
#define BW_RNG_CR_SLP(x, v)  (BITBAND_ACCESS32(HW_RNG_CR_ADDR(x), BP_RNG_CR_SLP) = (v))
/*@}*/

/*******************************************************************************
 * HW_RNG_SR - RNGA Status Register
 ******************************************************************************/

/*!
 * @brief HW_RNG_SR - RNGA Status Register (RO)
 *
 * Reset value: 0x00010000U
 *
 * Indicates the status of RNGA. This register is read-only.
 */
typedef union _hw_rng_sr
{
    uint32_t U;
    struct _hw_rng_sr_bitfields
    {
        uint32_t SECV : 1;             /*!< [0] Security Violation */
        uint32_t LRS : 1;              /*!< [1] Last Read Status */
        uint32_t ORU : 1;              /*!< [2] Output Register Underflow */
        uint32_t ERRI : 1;             /*!< [3] Error Interrupt */
        uint32_t SLP : 1;              /*!< [4] Sleep */
        uint32_t RESERVED0 : 3;        /*!< [7:5]  */
        uint32_t OREG_LVL : 8;         /*!< [15:8] Output Register Level */
        uint32_t OREG_SIZE : 8;        /*!< [23:16] Output Register Size */
        uint32_t RESERVED1 : 8;        /*!< [31:24]  */
    } B;
} hw_rng_sr_t;

/*!
 * @name Constants and macros for entire RNG_SR register
 */
/*@{*/
#define HW_RNG_SR_ADDR(x)        ((x) + 0x4U)

#define HW_RNG_SR(x)             (*(__I hw_rng_sr_t *) HW_RNG_SR_ADDR(x))
#define HW_RNG_SR_RD(x)          (HW_RNG_SR(x).U)
/*@}*/

/*
 * Constants & macros for individual RNG_SR bitfields
 */

/*!
 * @name Register RNG_SR, field SECV[0] (RO)
 *
 * Used only when high assurance is enabled (CR[HA]). Indicates that a security
 * violation has occurred.This field is sticky. To clear SR[SECV], you must reset
 * RNGA.
 *
 * Values:
 * - 0 - No security violation
 * - 1 - Security violation
 */
/*@{*/
#define BP_RNG_SR_SECV       (0U)          /*!< Bit position for RNG_SR_SECV. */
#define BM_RNG_SR_SECV       (0x00000001U) /*!< Bit mask for RNG_SR_SECV. */
#define BS_RNG_SR_SECV       (1U)          /*!< Bit field size in bits for RNG_SR_SECV. */

/*! @brief Read current value of the RNG_SR_SECV field. */
#define BR_RNG_SR_SECV(x)    (BITBAND_ACCESS32(HW_RNG_SR_ADDR(x), BP_RNG_SR_SECV))
/*@}*/

/*!
 * @name Register RNG_SR, field LRS[1] (RO)
 *
 * Indicates whether the most recent read of OR[RANDOUT] caused an OR underflow
 * condition, regardless of whether the error interrupt is masked (CR[INTM]). An
 * OR underflow condition occurs when you read OR[RANDOUT] and SR[OREG_LVL]=0.
 * After you read this register, RNGA writes 0 to this field.
 *
 * Values:
 * - 0 - No underflow
 * - 1 - Underflow
 */
/*@{*/
#define BP_RNG_SR_LRS        (1U)          /*!< Bit position for RNG_SR_LRS. */
#define BM_RNG_SR_LRS        (0x00000002U) /*!< Bit mask for RNG_SR_LRS. */
#define BS_RNG_SR_LRS        (1U)          /*!< Bit field size in bits for RNG_SR_LRS. */

/*! @brief Read current value of the RNG_SR_LRS field. */
#define BR_RNG_SR_LRS(x)     (BITBAND_ACCESS32(HW_RNG_SR_ADDR(x), BP_RNG_SR_LRS))
/*@}*/

/*!
 * @name Register RNG_SR, field ORU[2] (RO)
 *
 * Indicates whether an OR underflow condition has occurred since you last read
 * this register (SR) or RNGA was reset, regardless of whether the error
 * interrupt is masked (CR[INTM]). An OR underflow condition occurs when you read
 * OR[RANDOUT] and SR[OREG_LVL]=0. After you read this register, RNGA writes 0 to this
 * field.
 *
 * Values:
 * - 0 - No underflow
 * - 1 - Underflow
 */
/*@{*/
#define BP_RNG_SR_ORU        (2U)          /*!< Bit position for RNG_SR_ORU. */
#define BM_RNG_SR_ORU        (0x00000004U) /*!< Bit mask for RNG_SR_ORU. */
#define BS_RNG_SR_ORU        (1U)          /*!< Bit field size in bits for RNG_SR_ORU. */

/*! @brief Read current value of the RNG_SR_ORU field. */
#define BR_RNG_SR_ORU(x)     (BITBAND_ACCESS32(HW_RNG_SR_ADDR(x), BP_RNG_SR_ORU))
/*@}*/

/*!
 * @name Register RNG_SR, field ERRI[3] (RO)
 *
 * Indicates whether an OR underflow condition has occurred since you last
 * cleared the error interrupt (CR[CLRI]) or RNGA was reset, regardless of whether the
 * error interrupt is masked (CR[INTM]). An OR underflow condition occurs when
 * you read OR[RANDOUT] and SR[OREG_LVL]=0. After you reset the error-interrupt
 * indicator (via CR[CLRI]), RNGA writes 0 to this field.
 *
 * Values:
 * - 0 - No underflow
 * - 1 - Underflow
 */
/*@{*/
#define BP_RNG_SR_ERRI       (3U)          /*!< Bit position for RNG_SR_ERRI. */
#define BM_RNG_SR_ERRI       (0x00000008U) /*!< Bit mask for RNG_SR_ERRI. */
#define BS_RNG_SR_ERRI       (1U)          /*!< Bit field size in bits for RNG_SR_ERRI. */

/*! @brief Read current value of the RNG_SR_ERRI field. */
#define BR_RNG_SR_ERRI(x)    (BITBAND_ACCESS32(HW_RNG_SR_ADDR(x), BP_RNG_SR_ERRI))
/*@}*/

/*!
 * @name Register RNG_SR, field SLP[4] (RO)
 *
 * Specifies whether RNGA is in Sleep or Normal mode. You can also enter Sleep
 * mode by asserting the DOZE signal.
 *
 * Values:
 * - 0 - Normal mode
 * - 1 - Sleep (low-power) mode
 */
/*@{*/
#define BP_RNG_SR_SLP        (4U)          /*!< Bit position for RNG_SR_SLP. */
#define BM_RNG_SR_SLP        (0x00000010U) /*!< Bit mask for RNG_SR_SLP. */
#define BS_RNG_SR_SLP        (1U)          /*!< Bit field size in bits for RNG_SR_SLP. */

/*! @brief Read current value of the RNG_SR_SLP field. */
#define BR_RNG_SR_SLP(x)     (BITBAND_ACCESS32(HW_RNG_SR_ADDR(x), BP_RNG_SR_SLP))
/*@}*/

/*!
 * @name Register RNG_SR, field OREG_LVL[15:8] (RO)
 *
 * Indicates the number of random-data words that are in OR[RANDOUT], which
 * indicates whether OR[RANDOUT] is valid.If you read OR[RANDOUT] when SR[OREG_LVL]
 * is not 0, then the contents of a random number contained in OR[RANDOUT] are
 * returned, and RNGA writes 0 to both OR[RANDOUT] and SR[OREG_LVL].
 *
 * Values:
 * - 0 - No words (empty)
 * - 1 - One word (valid)
 */
/*@{*/
#define BP_RNG_SR_OREG_LVL   (8U)          /*!< Bit position for RNG_SR_OREG_LVL. */
#define BM_RNG_SR_OREG_LVL   (0x0000FF00U) /*!< Bit mask for RNG_SR_OREG_LVL. */
#define BS_RNG_SR_OREG_LVL   (8U)          /*!< Bit field size in bits for RNG_SR_OREG_LVL. */

/*! @brief Read current value of the RNG_SR_OREG_LVL field. */
#define BR_RNG_SR_OREG_LVL(x) (HW_RNG_SR(x).B.OREG_LVL)
/*@}*/

/*!
 * @name Register RNG_SR, field OREG_SIZE[23:16] (RO)
 *
 * Indicates the size of the Output (OR) register in terms of the number of
 * 32-bit random-data words it can hold.
 *
 * Values:
 * - 1 - One word (this value is fixed)
 */
/*@{*/
#define BP_RNG_SR_OREG_SIZE  (16U)         /*!< Bit position for RNG_SR_OREG_SIZE. */
#define BM_RNG_SR_OREG_SIZE  (0x00FF0000U) /*!< Bit mask for RNG_SR_OREG_SIZE. */
#define BS_RNG_SR_OREG_SIZE  (8U)          /*!< Bit field size in bits for RNG_SR_OREG_SIZE. */

/*! @brief Read current value of the RNG_SR_OREG_SIZE field. */
#define BR_RNG_SR_OREG_SIZE(x) (HW_RNG_SR(x).B.OREG_SIZE)
/*@}*/

/*******************************************************************************
 * HW_RNG_ER - RNGA Entropy Register
 ******************************************************************************/

/*!
 * @brief HW_RNG_ER - RNGA Entropy Register (WORZ)
 *
 * Reset value: 0x00000000U
 *
 * Specifies an entropy value that RNGA uses in addition to its ring oscillators
 * to seed its pseudorandom algorithm. This is a write-only register; reads
 * return all zeros.
 */
typedef union _hw_rng_er
{
    uint32_t U;
    struct _hw_rng_er_bitfields
    {
        uint32_t EXT_ENT : 32;         /*!< [31:0] External Entropy */
    } B;
} hw_rng_er_t;

/*!
 * @name Constants and macros for entire RNG_ER register
 */
/*@{*/
#define HW_RNG_ER_ADDR(x)        ((x) + 0x8U)

#define HW_RNG_ER(x)             (*(__O hw_rng_er_t *) HW_RNG_ER_ADDR(x))
#define HW_RNG_ER_RD(x)          (HW_RNG_ER(x).U)
#define HW_RNG_ER_WR(x, v)       (HW_RNG_ER(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual RNG_ER bitfields
 */

/*!
 * @name Register RNG_ER, field EXT_ENT[31:0] (WORZ)
 *
 * Specifies an entropy value that RNGA uses in addition to its ring oscillators
 * to seed its pseudorandom algorithm.Specifying a value for this field is
 * optional but recommended. You can write to this field at any time during operation.
 */
/*@{*/
#define BP_RNG_ER_EXT_ENT    (0U)          /*!< Bit position for RNG_ER_EXT_ENT. */
#define BM_RNG_ER_EXT_ENT    (0xFFFFFFFFU) /*!< Bit mask for RNG_ER_EXT_ENT. */
#define BS_RNG_ER_EXT_ENT    (32U)         /*!< Bit field size in bits for RNG_ER_EXT_ENT. */

/*! @brief Format value for bitfield RNG_ER_EXT_ENT. */
#define BF_RNG_ER_EXT_ENT(v) ((uint32_t)((uint32_t)(v) << BP_RNG_ER_EXT_ENT) & BM_RNG_ER_EXT_ENT)

/*! @brief Set the EXT_ENT field to a new value. */
#define BW_RNG_ER_EXT_ENT(x, v) (HW_RNG_ER_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_RNG_OR - RNGA Output Register
 ******************************************************************************/

/*!
 * @brief HW_RNG_OR - RNGA Output Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * Stores a random-data word generated by RNGA.
 */
typedef union _hw_rng_or
{
    uint32_t U;
    struct _hw_rng_or_bitfields
    {
        uint32_t RANDOUT : 32;         /*!< [31:0] Random Output */
    } B;
} hw_rng_or_t;

/*!
 * @name Constants and macros for entire RNG_OR register
 */
/*@{*/
#define HW_RNG_OR_ADDR(x)        ((x) + 0xCU)

#define HW_RNG_OR(x)             (*(__I hw_rng_or_t *) HW_RNG_OR_ADDR(x))
#define HW_RNG_OR_RD(x)          (HW_RNG_OR(x).U)
/*@}*/

/*
 * Constants & macros for individual RNG_OR bitfields
 */

/*!
 * @name Register RNG_OR, field RANDOUT[31:0] (RO)
 *
 * Stores a random-data word generated by RNGA. This is a read-only field.Before
 * reading RANDOUT, be sure it is valid (SR[OREG_LVL]=1).
 *
 * Values:
 * - 0 - Invalid data (if you read this field when it is 0 and SR[OREG_LVL] is
 *     0, RNGA then writes 1 to SR[ERRI], SR[ORU], and SR[LRS]; when the error
 *     interrupt is not masked (CR[INTM]=0), RNGA also asserts an error interrupt
 *     request to the interrupt controller).
 */
/*@{*/
#define BP_RNG_OR_RANDOUT    (0U)          /*!< Bit position for RNG_OR_RANDOUT. */
#define BM_RNG_OR_RANDOUT    (0xFFFFFFFFU) /*!< Bit mask for RNG_OR_RANDOUT. */
#define BS_RNG_OR_RANDOUT    (32U)         /*!< Bit field size in bits for RNG_OR_RANDOUT. */

/*! @brief Read current value of the RNG_OR_RANDOUT field. */
#define BR_RNG_OR_RANDOUT(x) (HW_RNG_OR(x).U)
/*@}*/

/*******************************************************************************
 * hw_rng_t - module struct
 ******************************************************************************/
/*!
 * @brief All RNG module registers.
 */
#pragma pack(1)
typedef struct _hw_rng
{
    __IO hw_rng_cr_t CR;                   /*!< [0x0] RNGA Control Register */
    __I hw_rng_sr_t SR;                    /*!< [0x4] RNGA Status Register */
    __O hw_rng_er_t ER;                    /*!< [0x8] RNGA Entropy Register */
    __I hw_rng_or_t OR;                    /*!< [0xC] RNGA Output Register */
} hw_rng_t;
#pragma pack()

/*! @brief Macro to access all RNG registers. */
/*! @param x RNG module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_RNG(RNG_BASE)</code>. */
#define HW_RNG(x)      (*(hw_rng_t *)(x))

#endif /* __HW_RNG_REGISTERS_H__ */
/* EOF */
