#include "storage.h"

/* Function: writeByte
 * -------------------
 * This function writes a byte of data to the EEPROM at the appropriate location.
 * This is called by my write.
 * Use this if you want to write a single byte.
 */
HAL_StatusTypeDef Storage::writeByte(uint8_t byte)
 {
    HAL_StatusTypeDef  status;
    int address = offset + stadr;
    offset++;
    HAL_FLASHEx_DATAEEPROM_Unlock();  //Unprotect the EEPROM to allow writing
    status = HAL_FLASHEx_DATAEEPROM_Program(TYPEPROGRAMDATA_BYTE, address, byte);
    HAL_FLASHEx_DATAEEPROM_Lock();  // Reprotect the EEPROM
    return status;
}

/* Function: write
 * ---------------
 * This function takes an array of bytes and its size and writes them to the EEPROM
 * Use this if you want to write a lot of bytes.
 */
void Storage::write(uint8_t* data, uint8_t size)
{
    for(int i = 0; i < size; i++)
    {
        writeByte(data[i]);
    }
}

/* Function: readByte
 * ------------------
 * This function reads a byte of data from the EEPROM at the offset passed in.
 * This is called by my read function.
 */
uint8_t Storage::readByte(uint32_t off) {
    uint8_t tmp = 0;
    off = off + stadr;
    tmp = *(__IO uint32_t*)off;
    
    return tmp;
}

/* Function: read
 * ---------------
 * This takes an array of bytes an fills it with our entire EEPROM
 * Call this function when you want to send the data over GSM
 */
void Storage::read(uint8_t *ptr)
{
    int nbytes = offset;
    printf("The number of bytes in the EEPROM is %d\n", nbytes);
    for(int i = 0; i < nbytes; i++)
    {
        ptr[i] = readByte(i);
    }
    return;
}