#include "main.h"

//define where the EEPROM begins
#define stadr 0x08080000

#ifndef _STORAGE_CLASS
#define _STORAGE_CLASS

/* Class: Storage
 * --------------
 * Implements the EEPROM perminant storage. Modifed code
 * from a posting by mbed user Darius Wilkinson. 
 * 
 * Found here: https://developer.mbed.org/forum/mbed/topic/4912/?page=1#comment-27406
 */
class Storage {
    public:
        void write(uint8_t* data, uint8_t size);
        void read(uint8_t *ptr);
        void reset() { offset = 0; };
    private:
        HAL_StatusTypeDef writeByte(uint8_t byte);
        uint8_t readByte(uint32_t off);
        int offset;
        int roffset;
};

#endif