#include "Adafruit_FONA.h"
#include "main.h"
#include "storage.h"

#define FONA_BAUD_RATE 9600     // FONA baud rate
#define ENABLE_GPRS_ATTEMPTS 5  // Number of attempts to enable GPRS if it fails

#ifndef _GSM_WRAPPER_CLASS
#define _GSM_WRAPPER_CLASS

/* Class: GSM_Sensor
 * -----------------
 * A "wrapper" class for the GSM library, abstracting
 * the Adafruit GSM library for use in this project.
 */
class GSM_Sensor {
    public:
        GSM_Sensor(): fona(FONA_TX, FONA_RX, FONA_RST, FONA_RI), key(FONA_KEY) {}
        void changePowerState();
        void setup();
        bool send(uint8_t* data, size_t size);
    private:
        bool sendOverHTTP(char* url, uint8_t* data, int dlength);
        Adafruit_FONA fona;
        DigitalOut key;
};

#endif