#include "GSM_Wrapper.h"

/* Function: changePowerState
 * --------------------------
 * Changes the power state by pulling the
 * key to ground for 2 seconds (write(0)). No
 * other way to turn GSM on/off.
 */
void GSM_Sensor::changePowerState()
{
    key.write(1);
    wait(2);
    key.write(0);
    wait(2);
    key.write(1);
    wait(2);
}

/* Function: setup
 * ---------------
 * Has to be called each time the FONA
 * is turned on. Sets the baud rate. Attempts
 * to change the power state to turn it on if it
 * fails. Sets up the network settings, then
 * attempts to enable GPRS for ENABLE_GPRS_ATTEMPTS times.
 */
void GSM_Sensor::setup()
{
    printf("Starting FONA\n");
    if(!fona.begin(FONA_BAUD_RATE)){
        changePowerState();
        printf("Cannot find FONA\n");
        wait(2);
    }
    if(!fona.begin(FONA_BAUD_RATE)){
        changePowerState(); 
        return;
    }
    printf("After begin\n");
    fona.setGPRSNetworkSettings(NETWORK_APN, "", ""); // Note: May need to change other fields for different SIM cards
    printf("After set setting\n");
    bool enable = false;
    int i = 0;
    while(enable != true) {
        if(i > ENABLE_GPRS_ATTEMPTS) break;
        i++;
        fona.enableGPRS(true);
        fona.enableGPRS(false);
        enable = fona.enableGPRS(true);
    }
    printf("After enable\n");
}

/* Function: sendOverHTTP
 * ----------------------
 * Sends the data over HTTP to the given URL.
 */
bool GSM_Sensor::sendOverHTTP(char* url, uint8_t* data, int dlength)
{
    uint16_t statuscode;
    int16_t length;
    if (!fona.HTTP_POST_start(url, "text/plain", data, dlength, &statuscode, (uint16_t *)&length)) {
        printf("Failed!\r\n");
        return false;
    }
    while (length > 0) {
        while (fona.readable()) {
            char c = fona.getc();
            putchar(c);
            length--;
            if (! length) break;
        }
    }
    printf("\r\n****\r\n");
    fona.HTTP_POST_end();
    return true;
}

/* Function: send
 * --------------
 * Public wrapper function for sendOverHTTP.
 */
bool GSM_Sensor::send(uint8_t* data, size_t size)
{
    setup();
    printf("Setup GSM\n");
    bool res = sendOverHTTP(URL, data, size);
    if(!res) res = sendOverHTTP(URL, data, size);
    printf("After sent data\n");   
    return res;
}