#include "main.h"
#include "MBed_Adafruit_GPS.h"

#define REFRESH_TIME 2000       // Refresh time in ms
#define N_GPS_QUERIES 300000    // Number of queries to send GPS -- changing may lose readings
#define SEC_WAIT_FOR_FIX 60     // Number of seconds to wait for the GPS to get a fix
#define GPS_BAUD 9600           // Sets the GPS baud rate

#ifndef _GPS_WRAPPER_CLASS
#define _GPS_WRAPPER_CLASS

/* Class: GPS_Sensor
 * ----------------
 * Defines a "wrapper" class for the Adafruit GPS
 * library. Abstracts their functions for use with
 * this project.
 */
class GPS_Sensor {
 public:
    GPS_Sensor() : gps_Serial(GPS_TX, GPS_RX), myGPS(&gps_Serial), gpsEN(GPS_EN){}
    void setup();
    void read(struct reading& lastReadingBuffer);
    void turnOff() { gpsEN.write(0); }
    void turnOn() { gpsEN.write(1); }
  
 private:
    Serial gps_Serial;
    Adafruit_GPS myGPS;
    DigitalOut gpsEN;
    Timer refresh_Timer;
};

#endif