#include "GPS_Wrapper.h"

/* Function: setup
 * ---------------
 * Initially sets up the GPS. Draws from the Adafruit GPS library.
 */
void GPS_Sensor::setup() {
    wait(2);
    turnOn();
    myGPS.begin(GPS_BAUD);
    myGPS.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCGGA); //these commands are defined in MBed_Adafruit_GPS.h; a link is provided there for command creation
    myGPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);
    myGPS.sendCommand(PGCMD_ANTENNA);
    wait(1);
    refresh_Timer.start();  //starts the clock on the timer
    printf("setupGPS seems to be fine\n");
    wait(2);
}

/* Function: read
 * --------------
 * Records a single reading to the reading struct passed by reference.
 */
void GPS_Sensor::read(struct reading& lastReadingBuffer) {
    // Continually checks for a GPS fix for SEC_WAIT_FOR_FIX (default = 60)
    for(int i = 0; i < SEC_WAIT_FOR_FIX; i++){
        wait(1);
        if(myGPS.fix) break;
    }
    printf("\n");
    for (int i = 0; i < N_GPS_QUERIES; i++) {
        char c = myGPS.read();   // Queries the GPS. When read via Adafruit_GPS::read(), the class returns single character stored here
        
        if (c) { printf("%c", c); } // This line will echo the GPS data if not paused
        
        //Check if we recieved a new message from GPS, if so, attempt to parse it,
        if ( myGPS.newNMEAreceived() ) {
            if ( !myGPS.parse(myGPS.lastNMEA()) ) {
                continue;   
            }    
        }
        // Check if enough time has passed to warrant printing GPS info to screen
        // Note if refresh_Time is too low or pcSerial.baud is too low, GPS data may be lost during printing
        if (refresh_Timer.read_ms() >= REFRESH_TIME ) {
            refresh_Timer.reset();
            printf("Time: %d:%d:%d.%u\n", myGPS.hour, myGPS.minute, myGPS.seconds, myGPS.milliseconds);   
            printf("Date: %d/%d/20%d\n", myGPS.day, myGPS.month, myGPS.year);
            printf("Fix: %d\n", (int) myGPS.fix);
            printf("Quality: %d\n", (int) myGPS.fixquality);
            
            lastReadingBuffer.hour = myGPS.hour;
            lastReadingBuffer.minutes = myGPS.minute;
            lastReadingBuffer.day = myGPS.day;
            lastReadingBuffer.month = myGPS.month;
            lastReadingBuffer.year = myGPS.year;
            lastReadingBuffer.latitude = 0.0;
            lastReadingBuffer.longitude = 0.0;
            if (myGPS.fix) {
                lastReadingBuffer.latitude = myGPS.latitude;
                if(myGPS.lat == 'S')
                    lastReadingBuffer.latitude *= -1;
                lastReadingBuffer.longitude = myGPS.longitude;
                if(myGPS.lon == 'W')
                    lastReadingBuffer.longitude *= -1;
                printf("Location: %5.2f%c, %5.2f%c\n", myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
                printf("Speed: %5.2f knots\n", myGPS.speed);
                printf("Angle: %5.2f\n", myGPS.angle);
                printf("Altitude: %5.2f\n", myGPS.altitude);
                printf("Satellites: %d\n", myGPS.satellites);
            }
        }
    }
    printf("\n");
}