#include "mbed.h"

#define URL ""                          //URL -- Required
#define NETWORK_APN "fast.tmobile.com"  //APN URL

#define N_READINGS_PER_SEND 5   // Readings to take before sending
#define N_SECONDS_SLEEP 360     // Seconds between readings

// Temperature sensor constant
#define TMP_ANALOG A0   // Analog communication for temperature sensor

// Global Positioning System constants
#define GPS_TX D6       // Denotes TX port on the Nucleo, attached to RX port on GPS
#define GPS_RX PB_11    // Likewise, TX port on GPS, RX on Nucleo
#define GPS_EN D7       // Enable pin for power on/off. Connected to a digital pin

// pH sensor constants
#define PH_TX PC_10     // Serial communication for pH
#define PH_RX PC_11     // Serial communication for pH

// Cellular communication constants
#define FONA_TX D8      // Serial communication for GSM
#define FONA_RX D2      // Serial communication for GSM
#define FONA_RST D3     // Required for ported Adafruit Library
#define FONA_RI D4      // "Ring Indicator" to recieve calls
#define FONA_KEY D5     // Turns FONA off/on (pull to GRND for 2 seconds to change state)

#define SIZE_OF_ENTRY (45+5*sizeof(int))    // Size of each entry when converted to a string in main.cpp:send();

#ifndef _MAIN_H
#define _MAIN_H
// Reading struct that includes the data for each reading we take
struct reading {
    float temperature;
    float pH;
    float latitude;     //Signed positive if N, negative if S
    float longitude;    //Signed positive if E, negative if W
    uint8_t day;
    uint8_t month;
    uint8_t year;
    uint8_t hour;
    uint8_t minutes;
};
#endif