/********************************************************************************************

   Filename: MC33926.h
   
   Original Author: Steven Kay

   Development Group: Steve!!

   Original Creation Date: April 2017

   Description: <Desc>

   Revision History: Version 1.0 - Initial Release

 *********************************************************************************************/

#ifndef MC33926_H
#define MC33926_H


#include "mbed.h"


#define DRIVER_PWM_PERIOD       1


#define RESET                   2
#define FORWARD                 1
#define REVERSE                 0


class MC33926
{
    
    public:
    
    MC33926(PinName pinIN1, PinName pinIN2, PinName pinFB); //   ", PinName pinSF"
        
    
    void SetPWMPulsewidth(int direction, float PWM_Pulsewidth);
    
    float ReadCurrentFeedback();
    
    // Implemented on v2.0
//    void StatusFlagWatch(bool latchPol);
//    bool GetStatus();
//    void ResetStatus();
        
    protected:
    
        PwmOut *_pinIN1;
        PwmOut *_pinIN2;
        AnalogIn *_pinFB;
        //InterruptIn *_pinSF;
        
        volatile bool statusFlag;
    
    
    void StatusFlagISR();

    
};

#endif
