/* FlashAir iSDIO sample
 * Copyright (C) 2018 by Junichi SHIBA, PIAX Inc.
 *
 * This file is a FlashAir iSDIO sample program code
 *  Released under the BSD 2-Clause license.
 *  http://flashair-developers.com/documents/license.html
 */
#include "mbed.h"
#include "FlashAir_iSDIO.h"

//#define USE_CONSOLE

#if defined(TARGET_LPC11U24)
FlashAir_iSDIO sd(p11, p12, p13, p14, "sd"); // MOSI, MISO, SCLK, SSEL
#elif defined(TARGET_LPC1114)
FlashAir_iSDIO sd(p11, p12, p13, p14, "sd"); // MOSI, MISO, SCLK, SSEL
#elif defined(TARGET_LPC1549)
FlashAir_iSDIO sd(D11, D12, D13, D10, "sd"); // MOSI, MISO, SCLK, SSEL
#elif defined(TARGET_NUCLEO_L073RZ) // TOYBOARD
Serial console(PA_9, PA_10); // TX, RX
FlashAir_iSDIO sd(PB_15, PB_14, PB_13, PB_12, "sd", &console); // mosi(CMD), miso(DAT0), sclk(CLK), cs(DAT3)
DigitalOut ledB(PB_11, 1); // B
DigitalOut ledG(PB_10, 1); // G
DigitalOut ledR(PA_15, 1); // R
DigitalOut SD_VEN(PC_4, 0); // SD initialy off
DigitalIn SD_CD(PC_1); // SD_CD
#elif defined(TARGET_LPC11U35_401) // Airio-Base
//#elif defined(TARGET_MCU_LPC11U35_501)
Serial console(P0_19, P0_18); // TX, RX
//Serial pc(USBTX, USBRX);
FlashAir_iSDIO sd(P0_21, P0_22, P1_15, P0_17, "sd", &console); // mosi(CMD), miso(DAT0), sclk(CLK), cs(DAT3)
DigitalOut ledB(P0_7, 1);
DigitalOut ledG(P0_7, 1);
DigitalOut ledR(P0_7, 1);
DigitalOut SD_VEN(P1_16);
DigitalIn SD_CD(P1_19);
#else
#error
#endif


//**************************************************

int main()
{
    uint32_t sequenceId ;
    ledG=0; ledB=0;
            
#ifdef USE_CONSOLE
    console.printf("start FlashAir iSDIO sample\n");
#endif
    
    // supply power to SD card
    SD_VEN = 1;
    wait(5.0);
    
    if (SD_CD) {
#ifdef USE_CONSOLE
        console.printf("SD: Not dected\n");
#endif
    } else {
#ifdef USE_CONSOLE
        console.printf("SD: Detected\n");
#endif
    }

    // Initialize card
    FILE *fp = fopen("/sd/isdio.txt", "w");
    fclose(fp);

    wait(15.0);
    ledG=1; ledB=1; ledR=0;
    
    // disconnect 
    // 1. get sequenceID
    // 2. issue disconnect command
    // 3. wait response 
    sequenceId = sd.getNextSequenceId();
    sd.wlan_disconnect(sequenceId);
    sd.waitResponse(sequenceId);
    wait(5.0);

    ledB = 0;

    // establish
    // 1. get sequenceID
    // 2. issue establish command
    // 3. wait resoonse        
    sequenceId = sd.getNextSequenceId();
    sd.wlan_establish(sequenceId, "isdiotest", "12345678", FlashAir_iSDIO::ENCMODE_WPA2PSK_AES);
    wait(5.0);
    ledG = 0;    

    // shared mem
    // 1. prepare test data
    // 2. write data to shared mem area
    // 3. read back and check
    #define TESTDATA 0xdeadbeaf
    uint32_t testdata = TESTDATA;
    uint8_t data[sizeof(testdata)];
    memcpy(data, &testdata, sizeof(data));
    sd.write_shared_mem(0x0, data, sizeof(data));
    memset(data, 0x0, sizeof(data));
    sd.read_shared_mem(0x0, data, sizeof(data));

    ledG=1; ledB=1; ledR=1;

    for(;;);
    
}
