/* mbed FlashAir iSDIO Library
 *  Copyright (C) 2018 by Junichi SHIBA, PIAX Inc
 *  All rights reserved.
 *  Released under the BSD 2-Clause license.
 *  http://flashair-developers.com/documents/license.html
 */
#include "mbed.h"
#include "FlashAir_iSDIO.h"


FlashAir_iSDIO::FlashAir_iSDIO(PinName mosi, PinName miso, PinName sclk, PinName cs, const char *name, Serial *console) :
    iSDIO(mosi, miso, sclk, cs, name, console)
{
    instance = this ;
    sequenceId = 0 ;
    _console = console ;
    if (_console != NULL)
    _console->printf("new FlashAIr_iSDIO\n");
}

FlashAir_iSDIO *FlashAir_iSDIO::instance = 0;

FlashAir_iSDIO *FlashAir_iSDIO::getInstance()
{
    return FlashAir_iSDIO::instance ;    
}

//uint32_t FlashAir_iSDIO::getSequenceId()
//{
//   return iSDIO::sequenceId ;
//}

uint8_t FlashAir_iSDIO::wlan_disconnect(uint32_t sequenceId) {
    if (_console != NULL)
  _console->printf("\nDisconnect command: \n");
  memset(cmdbuffer, 0, sizeof(cmdbuffer));
  uint8_t* p = cmdbuffer;
  p = put_command_header(p, 1, 0);
  p = put_command_info_header(p, WLAN_DISCONNECT, sequenceId, 0);
  put_command_header(cmdbuffer, 1, (p - cmdbuffer));
  printHex(cmdbuffer, (p - cmdbuffer));
//  return this.writeExtDataPort(1, 1, ISDIO_WRITE, cmdbuffer) ? true : false;
  return writeExtDataPort(1, 1, ISDIO_WRITE, cmdbuffer) ? 1 : 0;
}

uint8_t FlashAir_iSDIO::wlan_establish(uint32_t sequenceId, const uint8_t *ssid, const uint8_t *networkkey, const uint8_t encmode) {
    if (_console != NULL)
  _console->printf("\nEstablish command: \n");
  memset(cmdbuffer, 0, sizeof(cmdbuffer));
  uint8_t* p = cmdbuffer;
  p = put_command_header(p, 1, 0);
  p = put_command_info_header(p, WLAN_ESTABLISH, sequenceId, 3);
  p = put_str_arg(p, ssid);
  p = put_str_arg(p, networkkey);
  p = put_u8_arg(p, encmode);
  put_command_header(cmdbuffer, 1, (p - cmdbuffer));
  printHex(cmdbuffer, (p - cmdbuffer));
  return writeExtDataPort(1, 1, ISDIO_WRITE, cmdbuffer) ? 1 : 0;
}

uint8_t FlashAir_iSDIO::wlan_connect(uint32_t sequenceId, const uint8_t* ssid, const uint8_t* networkKey) {
    if (_console != NULL)
  _console->printf("\nConnect command: \n");
  memset(cmdbuffer, 0, sizeof(cmdbuffer));
  uint8_t* p = cmdbuffer;
  p = put_command_header(p, 1, 0);
  p = put_command_info_header(p, WLAN_CONNECT, sequenceId, 2);
  p = put_str_arg(p, ssid);
  p = put_str_arg(p, networkKey);
  put_command_header(cmdbuffer, 1, (p - cmdbuffer));
  printHex(cmdbuffer, (p - cmdbuffer));
  return writeExtDataPort(1, 1, ISDIO_WRITE, cmdbuffer) ? 1 : 0;
}

uint8_t FlashAir_iSDIO::wlan_scan(uint32_t sequenceId)
{
    if (_console != NULL)
    _console->printf("\nScan: \n");
    memset(cmdbuffer, 0, sizeof(cmdbuffer));
    uint8_t *p = cmdbuffer;
    p = put_command_header(p, 1, 0);
    p = put_command_info_header(p, WLAN_SCAN, sequenceId, 0);
    put_command_header(cmdbuffer, 1, (p-cmdbuffer));
    printHex(cmdbuffer, (p - cmdbuffer));
    return writeExtDataPort(MIO_IO, FUNC1, ISDIO_WRITE, cmdbuffer) ? true : false; 
}

uint8_t FlashAir_iSDIO::read_shared_mem(uint32_t offset, uint8_t* dst, uint16_t length)
{
    uint8_t ret ;
    
    ret = readExtMemory(MIO_IO, FUNC1, ISDIO_VENDOR+offset, length, dst);
    if (_console != NULL)
    _console->printf("read_shared_memory:\n");
    printHex((uint8_t*)dst, (uint32_t)length);
    return ret ;
}

uint8_t FlashAir_iSDIO::write_shared_mem(uint32_t offset, uint8_t* src, uint16_t length)
{
    if (_console != NULL)
    _console->printf("write_shared_mem:\n");
    printHex((uint8_t*)src, (uint32_t)length);

    return writeExtMemory(MIO_IO, FUNC1, ISDIO_VENDOR+offset, length, src);
}
