/* mbed FlashAir iSDIO Library
 *  Copyright (C) 2018 by Junichi SHIBA, PIAX Inc
 *  All rights reserved.
 *  Released under the BSD 2-Clause license.
 *  http://flashair-developers.com/documents/license.html
 */
#ifndef __FLASHAIR_ISDIO_H__
#define __FLASHAIR_ISDIO_H__

#include "mbed.h"
#include "SDFileSystem.h"
#include "iSDIO.h"

class FlashAir_iSDIO : public iSDIO
{
public:
    FlashAir_iSDIO(PinName mosi, PinName miso, PinName sclk, PinName cs, const char* name, Serial* console = NULL);

    static FlashAir_iSDIO* getInstance();
    
    uint8_t wlan_disconnect(uint32_t sequenceId);
    uint8_t wlan_establish(uint32_t sequenceId, const uint8_t *ssid, const uint8_t *networkkey, const uint8_t encmode);
    uint8_t wlan_connect(uint32_t sequenceId, const uint8_t* ssid, const uint8_t* networkKey);
    uint8_t wlan_scan(uint32_t sequenceId);
    uint8_t read_shared_mem(uint32_t offset, uint8_t* dst, uint16_t length);
    uint8_t write_shared_mem(uint32_t offset, uint8_t* src, uint16_t length);
    static const uint8_t ENCMODE_WPA2PSK_AES=0x06;

protected:

    static FlashAir_iSDIO* instance;
//    uint8_t FlashAir_iSDIO_waitResponse(uint32_t sequenceId) ;

private:
#define CMDBUFLEN 512 // iSDIO command buffer length
    uint8_t cmdbuffer[CMDBUFLEN];
    Serial* _console ;
    
};

#endif  // __FLASHAIR_ISDIO_H__
