/* mbed SD iSDIO Library
 * Copyright (C) 2018 by Junichi SHIBA, PIAX Inc.
 *
 * Arduino Sdio Library
 * Copyright (C) 2014 by Munehiro Doi
 *
 * This file is an iSDIO extension of the Arduino Sd2Card Library
 * Copyright (C) 2009 by William Greiman
 *
 * This Library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the Arduino Sd2Card Library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */
#ifndef __ISDIO_H__
#define __ISDIO_H__

#include "mbed.h"
#include "SDFileSystem.h"
#include "iSDIO_template.h"

// Extention Register Commands
#define MIO_MEM 0
#define MIO_IO 1
#define FUNC1 1

// iSDIO register
#define ISDIO_BASE 0x000
#define ISDIO_WRITE_OFFSET 0x000
#define ISDIO_RESPONSE_OFFSET 0x200
#define ISDIO_STATUS_OFFSET 0x400
#define ISDIO_VENDOR_OFFSET 0x1000

#define ISDIO_WRITE (ISDIO_BASE + ISDIO_WRITE_OFFSET)
#define ISDIO_RESPONSE (ISDIO_BASE + ISDIO_RESPONSE_OFFSET)
#define ISDIO_STATUS (ISDIO_BASE + ISDIO_STATUS_OFFSET)
#define ISDIO_VENDOR (ISDIO_BASE + ISDIO_VENDOR_OFFSET)

#define ISDIO_STATUS_QUEUE_OFFSET 0x040
#define ISDIO_STATUS_QUEUE (ISDIO_STATUS + ISDIO_STATUS_QUEUE_OFFSET)
#define ISDIO_STATUS_QUEUE_SIZE 0x14


#define OFFSET_RESPONSE_DATA 24 // change structured data in the future
#define OFFSET_START_SSID 28
#define COMMAND_SEQUENCE_OFFSET 0x4
#define RESPONSE_STATUS_OFFSET 0x8

// iSDIO command
#define WLAN_SCAN 0x01
#define WLAN_CONNECT 0x02
#define WLAN_ESTABLISH 0x03
#define WLAN_DISCONNECT 0x07

//#define ENCMODE_WPA2PSK_AES 0x06

class iSDIO : public SDFileSystem
{
public:
    iSDIO(PinName mosi, PinName miso, PinName sclk, PinName cs, const char* name, Serial* console = NULL);

    static iSDIO* getInstance();
    uint32_t getSequenceId();
    uint32_t getNextSequenceId();
    
    virtual ~iSDIO();
    
    uint8_t readExtDataPort(uint8_t mio, uint8_t func, uint16_t addr, uint8_t* dst);
    uint8_t readExtMemory(uint8_t mio, uint8_t func, uint32_t addr, uint16_t count, uint8_t* dst);
    uint8_t writeExtDataPort(uint8_t mio, uint8_t func, uint16_t addr, const uint8_t* src);
    uint8_t writeExtMemory(uint8_t mio, uint8_t func, uint32_t addr, uint16_t count, const uint8_t* src);
    uint8_t writeExtMask(uint8_t mio, uint8_t func, uint32_t addr, uint8_t mask, const uint8_t* src);

    uint8_t waitResponse(uint32_t sequenceId);
    
private:
    Serial* _console ;
    
protected:
    uint8_t readExt(uint32_t arg, uint8_t* src, uint16_t count);
    uint8_t writeExt(uint32_t arg, const uint8_t* src, uint16_t count);

    static iSDIO* instance;
    uint32_t sequenceId;
    
    //for debug
    void printByte(uint8_t value);
    void printBytes(uint8_t* p, uint32_t len);
    void printHex(uint8_t* p, uint32_t len);
};

#endif  // __ISDIO_H__
