#ifndef MBED_ULTRASONIC_H
#define MBED_ULTRASONIC_H

#include "mbed.h"

class Ultrasonic
{
public:
    Ultrasonic(PinName trigPin, PinName echoPin, float tick = 0.1, bool repeat = false);
    ~Ultrasonic();

    void trig();
    int getDistance(void);
    int getPulseDuration(void);

    //the ultrasonic sensor will stop after measuring once, use clear to clear the value
    int getStatus(void);
    void clearStatus(void);

    void pauseMeasure(void);
    void setMode(bool mode);
private:
    DigitalOut _trig;
    InterruptIn _echo;

    Timer _timer;
    Ticker _ticker;
    float _toVal;
    bool _repeat;

    int _distance;
    int _pulseDuration;

    void _startT(void);
    void _endT(void);
    void _ticker_cb(void);
    int _done;
};

#endif MBED_ULTRASONIC_H