#include "Ultrasonic.h"

Ultrasonic::Ultrasonic(PinName trigPin, PinName echoPin, float tick, bool repeat)
    : _trig(trigPin), _echo(echoPin), _toVal(tick), _repeat(repeat)
{
    _done = 0;
    _timer.reset();
    _echo.rise(this, &Ultrasonic::_startT);
    _echo.fall(this, &Ultrasonic::_endT);
    if (_repeat) _ticker.attach(this, &Ultrasonic::_ticker_cb, _toVal);
}

Ultrasonic::~Ultrasonic() {}

void Ultrasonic::_startT(void)
{
    _timer.start();
}
void Ultrasonic::_endT(void)
{
    _timer.stop();
    _pulseDuration = _timer.read_us();
    _distance = _pulseDuration / 58;
    _timer.reset();
    _done = 1;
}


void Ultrasonic::trig()
{
    _echo.enable_irq();
    wait_us(2);
    _trig = 1;
    wait_us(10);
    _trig = 0;
}
void Ultrasonic::_ticker_cb(void)
{
    this->trig();
}

int Ultrasonic::getDistance(void)
{
    return _distance;
}
int Ultrasonic::getPulseDuration(void)
{
    return _pulseDuration;
}

void Ultrasonic::pauseMeasure(void)
{
    _repeat = false;
    _ticker.detach();
}
void Ultrasonic::setMode(bool mode)
{
    _repeat = mode;
    if (_repeat) _ticker.attach(this, &Ultrasonic::_ticker_cb, _toVal);
    else _ticker.detach();
}

int Ultrasonic::getStatus()
{
    return _done;
}
void Ultrasonic::clearStatus(void)
{
    _done = 0;
}