#include "Drive.h"

Drive::Drive(PinName pwmA, PinName pwmB, PinName Ain1, PinName Ain2, PinName Bin1, PinName Bin2):
    _pwmA(pwmA), _pwmB(pwmB), _AIN1(Ain1), _AIN2(Ain2), _BIN1(Bin1), _BIN2(Bin2){
}
        
Drive::~Drive(){
}
        
void Drive::Forward(){
    _pwmA.pulsewidth_us(left_Speed);
    _pwmB.pulsewidth_us(right_Speed);
    _AIN1 = LOW;
    _AIN2 = HIGH;
    _BIN1 = LOW;
    _BIN2 = HIGH;
}
        
void Drive::Backward(){
    _pwmA.pulsewidth_us(left_Speed);
    _pwmB.pulsewidth_us(right_Speed);
    _AIN1 = HIGH;
    _AIN2 = LOW;
    _BIN1 = HIGH;
    _BIN2 = LOW;
}
        
void Drive::Turn_left(){
    _pwmA.pulsewidth_us(left_Speed);
    _pwmB.pulsewidth_us(right_Speed);
    _AIN1 = HIGH;
    _AIN2 = LOW;
    _BIN1 = LOW;
    _BIN2 = HIGH;
}
        
void Drive::Turn_right(){
    _pwmA.pulsewidth_us(left_Speed);
    _pwmB.pulsewidth_us(right_Speed);
    _AIN1 = LOW;
    _AIN2 = HIGH;
    _BIN1 = HIGH;
    _BIN2 = LOW;
}

void Drive::Break(){
    _AIN1 = LOW;
    _AIN2 = LOW;
    _BIN1 = LOW;
    _BIN2 = LOW;
}

void Drive::setSpeed(int speed){
    left_Speed = speed;
    right_Speed = speed;
}

void Drive::setSpeed(int speed1, int speed2){
    left_Speed = speed1;
    right_Speed = speed2;
}
