#include "ultrasonic.h"

// generate a 10 us pulse to start HCSR04 ulrasonic sensor and
// enable IRQ for echo pin.
Ultrasonic::Ultrasonic(PinName trigPin, PinName echoPin, float timeout, bool mode, float time) :
    _trig(trigPin), _echo(echoPin), _toVal(timeout), _pc(PA_2, PA_3), _repeat(mode), _repeatD(time){
    _timer.reset();
    _echo.rise(this, &Ultrasonic::_startT);
    _echo.fall(this, &Ultrasonic::_endT);
    _echo.mode(PullUp);
    _echo.disable_irq();
    _pc.baud(115200);
}


Ultrasonic::~Ultrasonic(){}

int Ultrasonic::getDistance(void) {
    calculateDistance();
    return _distance;
}

void Ultrasonic::calculateDistance(void) {
    clearStatus();

    trig();
    getPulseDuration();

    if (_pulseDuration >= 0) _distance = _pulseDuration / 29 / 2;
    else _distance = -1;
    
}

void Ultrasonic::trig(void) {
    _echo.enable_irq();
    _trig = 1;
    wait_us(10);
    _trig = 0;
}

int Ultrasonic::getPulseDuration(void) {

    while (!_break) {
       _pc.printf("\r");
    }  // wait signal
    // we need to change 

    _break = 0;
    _echo.disable_irq();

    if (_end >= 0) _pulseDuration = _end - _start;
    else _pulseDuration = -1;
    
    return _pulseDuration;
}

int Ultrasonic::getStatus(void) {
    return _done;
}

void Ultrasonic::clearStatus(void) {
    _done          = 0;
    _pulseDuration = 0;
    _distance      = 0;
    _start         = -1;
    _end           = -1;
    _trig          = 0;
}

void Ultrasonic::pauseMeasure(void) {
    _done = 1;
}

void Ultrasonic::_startT(void) {
    _timer.start();
    _start = _timer.read_us();
    _timeout.attach(callback(this, &Ultrasonic::_timeout_cb), _toVal);
}

void Ultrasonic::_endT(void) {
    _timeout.detach();
    _end = _timer.read_us();
    _timer.stop();
    _timer.reset();
    _break = 1;
}

void Ultrasonic::_timeout_cb(void) {
    _timer.stop();
    _timer.reset();
    _break = 1;
}

void Ultrasonic::setMode(bool mode){
    _repeat = mode;
}

void Ultrasonic::printDistance(float interval){
    
    int num = (int)(1/interval);
    
    if(_repeat == true)
    {
        for(int i=0; i<num; i++)
        {
            _pc.printf("distance: %d\r\n", getDistance());
            wait(interval/2);
        }
    }
    
    else
        _pc.printf("distance: %d\r\n", getDistance());
        
    num = 0;
}
