#ifndef TRSensors_h
#define TRSensors_h

#include "mbed.h"
#include <cstdlib>

#define QTR_EMITTERS_OFF 0
#define QTR_EMITTERS_ON 1
#define QTR_EMITTERS_ON_AND_OFF 2

#define QTR_NO_EMITTER_PIN  255

#define QTR_MAX_SENSORS 16

class TRSensors{
    private:
        unsigned char _numSensors;
        
    public:
        TRSensors(PinName p1, PinName p2, PinName p3, PinName p4);
        ~TRSensors();
        void AnalogRead(uint16_t *sensor_value);
        void calibrate();
        void readCalibrated(uint16_t *sensor_values);
        uint16_t readLine(uint16_t *sensor_values, unsigned char white_line = 0);
        SPI spi;
        DigitalOut cs;
        uint16_t *calibratedMin;
        uint16_t *calibratedMax;
};

#endif
