#ifndef MBED_ULTRASONIC_H
#define MBED_ULTRASONIC_H

#include "mbed.h"

class Ultrasonic
{
public:
    /**iniates the class with the specified trigger pin, echo pin, update speed and timeout**/
    Ultrasonic(PinName trigPin, PinName echoPin, float timeout = 0.1, bool mode = false, float time = 0.1);

    ~Ultrasonic();

    // generate 10 us trig signal
    void trig(void);

    // return distance in cm and return -1 in case of failure
    int  getDistance(void);
    
    void calculateDistance(void);

    // return the echo pulse duration in us and return -1 in case of failure
    int  getPulseDuration(void);

    // get a status whether measurement is done or not
    int  getStatus(void);

    // clear the status that represents measurement-done.
    void clearStatus(void);

    // stop measuring
    void pauseMeasure(void);
    
    
    void setMode(bool mode);
    
    void printDistance(float interval);
    

private:
    DigitalOut  _trig;
    InterruptIn _echo;
    Timer   _timer;
    Timeout _timeout;
    Ticker  _t;
    float   _toVal; // timeout value in sec, or retriig time in sec if repeat == true
    float   _repeatD;
    bool    _repeat;
    int     _distance;
    int     _pulseDuration;
    int     _start;
    int     _end;
    int     _break;
    void _startT(void);
    void _endT(void);
    void _timeout_cb(void);
    int _done;  // end of measure
    RawSerial _pc;
};
#endif /* ifndef MBED_ULTRASONIC_H */

