#ifndef __DRIVE_H__
#define __DRIVE_H__

#include "mbed.h"

#define HIGH 1
#define LOW 0

class Drive{
    
    private:
        PwmOut _pwmA;
        PwmOut _pwmB;
        DigitalOut _AIN1;
        DigitalOut _AIN2;
        DigitalOut _BIN1;
        DigitalOut _BIN2;
        int left_Speed;
        int right_Speed;
    
    public:
        Drive(PinName pwmA, PinName pwmB, PinName Ain1, PinName Ain2, PinName Bin1, PinName Bin2);
        
        ~Drive();
        
        void Forward();
        
        void Backward();
        
        void Turn_left();
        
        void Turn_right();
        
        void Break();
        
        void setSpeed(int speed);
        
        void setSpeed(int speed1, int speed2);
};
#endif
