#include "mbed.h"
#include "SCP1000.h"
#include "Fastsensing.h"

DigitalOut myled(LED1);
DigitalIn button(p21);
Serial pc(USBTX, USBRX);
Fastsensing fast;
SCP1000 scp1000(p5,p6,p7,p8);

//Define User's Device Basic Information
char *deviceId = "Device ID(16 digits)";                        //Device ID
char *channel[3] = {"Channel ID(8 digits)", "Channel ID", "Channel ID"};    //Channel ID : 1st ID is temperature. 2nd is humidity.
    
int main() {
    float data[3];                                              //Data holder    
    fast.ethConnect();                                          //Ethernet connect 

    while(1) {
        data[0] = scp1000.readPressure(true);                   //substitute Pressure data to data[0]
        data[1] = scp1000.readTemperature(true);                //substitute Temperature data to data[1]
        pc.printf("The pressure is %f Pa and the temperature is %f C\n", data[0], data[1]);        //display pressure and temperature to PC
        int val = fast.updateDataAll(deviceId, channel, data);  //Send all got data to fastsensing.com
        pc.printf("res : %d\n", val);                           //updateDataAll result display
        myled = 1; 
        if(button == 1) break;
        wait(10.0);
        myled = 0;
    }
    fast.ethDisconnect();                                       //Ethernet disconnect
    while(1) {
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);    
    }
}