/*
MIT License

Copyright (c) 2017 Fast Sensing Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#include "Fastsensing.h"

int Fastsensing::updateData(char *deviceId, char *channelId, double data, int display)
{
    char basedHead[9] = "GET /d1/";                             //Query base header
    char basedFoot[36] = " HTTP/1.1\r\nHost: f-io.net\r\n\r\n"; //Query base Footer
    char req[256];                                              //req data array
    char query[128];                                            //query array

    //Error handling about deviceID length
    if(strlen(deviceId) != 16) {
        printf("Error1 : Device ID length is not correctly.\n");
        return -1;
    }

    //Error handling about deviceID length
    if(strlen(channelId) != 8) {
        printf("Error2 : Channel ID length is not correctly.\n");
        return -2;
    }

    //printf("Fastsensing update data\n");
    eth.connect();      //Connect bring the interface up
    const char *ip = eth.get_ip_address();  //Get my IP address
    //printf("My IP Address is %s\n", ip ? ip: "No IP");

    //Open Socket
    TCPSocket socket;   //Create a socket on a network interface
    int error = socket.open(&eth);      //Create a network socket
    socket.connect("f-io.net", 80);     //Connect remote host
    if(error < 0) {
        printf("Error3 : Error code is %d\n", error);   //If TCPSocket.open is failed, return error;
        return -3;                                      
    }

    //Create query
    strcpy(req, basedHead);                   //based Url is copied to req
    strcat(req, deviceId);                   //Concatenate req and deviceId
    sprintf(query, "?%s=%f", channelId, data);  //Create Query String
    //printf("query : %s\n", query);

    strcat(req, query);                     //Concatenate req and query
    strcat(req, basedFoot);                 //Concatenate req and basedFoot
    int scount = socket.send(req, sizeof req);                          //Count
    if(display == 1) printf("sent %d [%.*s]\n", scount, strstr(req, "\r\n")-req, req); //Send time and Send data display

    // Recieve response
    char rbuffer[64];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);                                  //Recieve count
    if(display == 1) printf("recv %d [%.*s]\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);     //Display Recieve data

    // Close the socket
    socket.close();

    eth.disconnect();   //EthernetInterface disconnected
    if(display == 1) printf("Data Update Process all completed\n");

    return 0;
}

int Fastsensing::updateDataAll(char *deviceId, char *channelId[3], float data[3], int display)
{
    char basedHead[9] = "GET /d1/";                             //query base header
    char basedFoot[36] = " HTTP/1.1\r\nHost: f-io.net\r\n\r\n"; //query base footer
    char delim;                                                 //delimiter
    char req[512];                                              //request array
    char query[128];                                            //query array

    //Error handling about deviceID length
    if(strlen(deviceId) != 16) {
        printf("Error1 : Device ID length is not correctly.\n");
        return -1;
    }

    //Error handling about channelID length
    for(int a = 0; a < 3; a++) {
        if(strlen(channelId[a]) != 8) {
            printf("Error2 : Channel ID length is not correctly.\n");
            return -2;
        }
    }

    //printf("Fastsensing update all channel data\n");
    eth.connect();      //Connect bring the interface up
    const char *ip = eth.get_ip_address();  //Get my IP address
    //printf("My IP Address is %s\n", ip ? ip: "No IP");

    //Open Socket
    TCPSocket socket;   //Create a socket on a network interface
    int open_error = socket.open(&eth);      //Create a network socket with ip address(stack)
    socket.connect("f-io.net", 80);     //Connect remote host
    if(open_error < 0){
        printf("Error3 : Error code is %d\n", error);   //If TCPSocket.open is failed, return error;
        return -3;                                      
    }

    //Create query
    strcpy(req, basedHead);                   //based Url is copied to req
    strcat(req, deviceId);                   //Concatenate req and deviceId
    for(int i = 0; i < 3; i++) {                                //Create request URL
        if(i == 0) delim = '?';                                 //first query is connected with ?
        else delim = '&';                                       //After second, query is connected with &
        sprintf(query, "%c%s=%.1f",delim, channelId[i], data[i]); //Create Query String
        strcat(req, query);                     //Concatenate req and query
    }
    strcat(req, basedFoot);                 //Concatenate req and basedFoot
    int scount = socket.send(req, sizeof req);                          //Count
    if(display == 1) printf("sent %d [%.*s]\n", scount, strstr(req, "\r\n")-req, req); //Send time and Send data display

    // Recieve response
    char rbuffer[64];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);                                  //Recieve count
    if(display == 1) printf("recv %d [%.*s]\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);     //Display Recieve data

    // Close the socket
    socket.close();

    eth.disconnect();   //EthernetInterface disconnected
    if(display == 1) printf("Data Update Process all completed\n");

    return 0;
}