//==============================================================================
//  FabLab Nîmes
//  Initiation à la Programmation
//  Auteur : Frédéric Giamarchi

//  Date : 06 janv. 2022
//  TP : Mesure de la température par une résistance CTN de 4,7k Ohm
//  Affichage de la température sur le PC
//==============================================================================
//              Déclarations des ressources
#include "mbed.h"

//==============================================================================
//              Déclaration des broches
DigitalOut  DEL_RO(PA_11);              // Ligne PA_11 sur la carte Nucléo
Serial      pc(USBTX, USBRX);           // Dialogue Série port USB à 9600 Baud
AnalogIn    POT(PA_0);                  // Ligne PA_0 en entrée analogique

//==============================================================================
//              Déclaration des variables
uint8_t variable;                        // variable de type entier (0 à 255)
char c;                                 // variable de type caractère
float temp, temp_mes;                           // variable de type réel
uint16_t mesure;

//==============================================================================
//              Déclaration des Fonctions
float tab[100];
uint8_t k;
float somme;

//  Fonction qui calcule la moyenne de x valeurs et renvoit un résultat
float Moyenne(float valeur, uint8_t nb)
{
    somme = somme - tab[k]+  valeur;    // Calcul de la somme
    tab[k] = valeur;                    // Mémorise la nouvelle valeur dans le tableau
     
    k++;
    if (k == nb)                        // Limitation du tableau à "nb" valeurs
        k = 0;

    return somme / nb;                  // Calcule de la moyenne et renvoit le résultat
}

//==============================================================================
//              Début du Programme
int main()                              // Fonction principale
{ 
    pc.printf("\r\nFabLab TP Mesure Temperature\r\n\n");
    k = 0;
    
//==============================================================================
//              Boucle Infinie
    while(1)
    {
//        mesure = POT.read()*3.3f;       // Mesure de la tension
        mesure = POT.read_u16()>>4;         // Mesure de la valeur numérique alignée à gauche qui doit être replacer à droite  
        temp = (mesure - 966)*0.023f - 2;   // Linéarisation et correction
        temp_mes = temp;                    // Température mesurée
        temp = Moyenne (temp,50);           // Calcul de la moyenne sur 50 valeurs
        
        wait_ms(50);
        pc.printf("Mes: %.1f  Moy: %.1f\r\n",temp_mes,temp);
        
    }           // Fin du while(1)
//==============================================================================
}               // Fin du Programme
//==============================================================================