//==============================================================================
//  FabLab Nîmes
//  Initiation à la Programmation
//  Auteur : Frédéric Giamarchi

//  Date : 16 dec. 2021
//  TP 03 : Controle de la luminosité d'une DEL par une résistance variable
//  Lecture d'une entrée analogique (Résistance variable)
//  Gestion de la luminosité d'une DEL par temporisation (Solution n°1)
//  Génération d'un signal MLI (PWM) (Solution n°2)
//==============================================================================
//              Déclarations des ressources
#include "mbed.h"

//==============================================================================
//              Déclaration des broches
//DigitalOut  DEL(PA_11);              // Ligne PA_11 sur la carte Nucléo
AnalogIn    POT(PA_3);                  // Ligne PA_0 en entrée analogique
//              Solution n°2
PwmOut      DEL(PA_11);                 // Ligne PA_11 en mode PWM

//==============================================================================
//              Déclaration des variables
float mesure;                           // variable de type réel

//==============================================================================
//              Début du Programme
int main()                              // Fonction principale
{
    mesure = 0;                         // Initialisation de la variable
//              Solution n°2
    DEL.period_ms(20);                // Définit la période du signal
//==============================================================================
    while(1) {                          // Boucle Infinie

//              Solution n°1
//        mesure = POT.read()*20;         // Valeur comprise entre 0 et 20    
//        DEL_RO = 1;
//        wait_ms(mesure);                // Durée Del allumée
//        DEL_RO = 0;
//        wait_ms(20 - mesure);           // Durée DEl éteinte
//              Solution n°2
        mesure = POT.read();            // Valeur comprise entre 0 et 1
        DEL.write(mesure);              // Définit le rapport cyclique (Temps Haut/Période) de 0 à 1

    }           // Fin du while(1)
//==============================================================================
}               // Fin du Programme
//==============================================================================