//==============================================================================
//  FabLab Nîmes
//  Initiation à la Programmation
//  Auteur : Frédéric Giamarchi

//  Date : 19 nov 2021
//  TP 01 : Controle de 3 DELs en même temps
//  Modifier le programme pour obtenir que 3 Dels (Rouge, Jaune et Verte)
//  clignotent à 3 fréquences différentes (1Hz, 2Hz et 4Hz).

//  Correction
//==============================================================================
#include "mbed.h"

//              Déclaration du sens des broches
DigitalOut DEL_RO(PA_11);               // Ligne PA_11 sur la carte Nucléo
DigitalOut DEL_JA(PB_5);               // Ligne PB_5 sur la carte Nucléo
DigitalOut DEL_VE(PB_4);               // Ligne PB_4 sur la carte Nucléo

//              Déclaration des variables    
uint8_t compteur;                       //

//==============================================================================
//              Début du Programme
int main()                              // Fonction principale
{

//==============================================================================
    while(1)                            // Boucle Infinie
    {
//              Solution n°1
/*      
        DEL_RO = 1;
        DEL_JA = 1;
        DEL_VE = 1;                     // Broche à 1 (DEL Verte allumée)
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
        DEL_VE = 0;                     // Broche à 0 (DEL Verte éteinte)
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
        DEL_JA = 0;
        DEL_VE = 1;                     // Broche à 0 (DEL Verte éteinte)
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
        DEL_VE = 0;                     // Broche à 0 (DEL Verte éteinte)
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
        DEL_RO = 0;
        DEL_JA = 1;
        DEL_VE = 1;                     // Broche à 1 (DEL Verte allumée)
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
        DEL_VE = 0;                     // Broche à 0 (DEL Verte éteinte)
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
        DEL_JA = 0;
        DEL_VE = 1;                     // Broche à 0 (DEL Verte éteinte)
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
        DEL_VE = 0;                     // Broche à 0 (DEL Verte éteinte)
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
*/
//              Solution n°2
/*      
        DEL_RO = !DEL_RO;               // Inversion logique sur la broche
        DEL_JA = !DEL_JA;
        DEL_VE = !DEL_VE;
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
        DEL_VE = !DEL_VE;                     // Broche à 0 (DEL Verte éteinte)
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
        DEL_JA = !DEL_JA;
        DEL_VE = !DEL_VE;                     // Broche à 0 (DEL Verte éteinte)
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
        DEL_VE = !DEL_VE;                     // Broche à 0 (DEL Verte éteinte)
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
*/
//              Solution n°3
        wait_ms(125);                   // Temporisation de 125ms (0.125s)
        compteur = compteur + 1;
        DEL_VE = compteur & 0x01;
        DEL_JA = compteur & 0x02;
        DEL_RO = compteur & 0x04;
    }           // Fin du while(1)
//==============================================================================
}               // Fin du Programme
//==============================================================================