//==============================================================================
//  FabLab Nîmes
//  Initiation à la Programmation
//  Auteur : Frédéric Giamarchi

//  Date : 04 juin 2022
//  TP : Station Meteo
//  
//  Utilisation de fonctions décrites dans un fichier séparé
//==============================================================================
//              Déclarations des ressources
#include "mbed.h"
#include "fonctions.h"                  // Appel des fonctions du fichier : fonctions.h
#include "serial.h"
#include "anemo.h"

//==============================================================================
//              Déclaration des variables
unsigned char c;                                 // variable de type caractère
float temp;                             // variable de type réel
unsigned int vitesse;                        // variable de type 16 bits signée
unsigned int etat;
unsigned int cmd_menu;

//==============================================================================
//              Début du Programme
int main()                              // Fonction principale
{
   Init_Fonctions();                   // Exécute cette fonction


    Init_Serial();

    etat = 0;
//==============================================================================
//              Boucle Infinie
    while(true)
    {
        Commande_Up();                  // Lecture d'une commande montante

        switch (etat)
        {
            case 0:                         // Initialisation du système
                Init_Anemo();
                
                cmd_menu = 0;
                etat = 1;
                break;
            case 1:                         // Menu
                Menu();
                cmd_menu = Get_Config();
                etat = 2;
                break;
            case 2:                         // Gestion des Instrumesnts
                // Gestion_Temperature(cmd_menu);
                Gestion_Anemometre(cmd_menu);
                // Gestion_Girouette(cmd_menu);
                // Gestion_Pluviometre(cmd_menu);
                etat = 3;
                break;
            case 3:                         // Gestion des données
                vitesse = Lecture_Anemometre();
                if(vitesse > 0)
                {
                    pc.printf("#A%d\r\n",vitesse);
                }
                etat = 1;
                break;
            default:
                etat = 0;
                break;
        }
    }//         Fin du while(true)
//==============================================================================
}//             Fin du Programme
//==============================================================================
